% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{inference_inla}
\alias{inference_inla}
\title{Run inference}
\usage{
inference_inla(prior_obj, use_likelihood = TRUE, print_prior = TRUE, ...)
}
\arguments{
\item{prior_obj}{An object from \link[makemyprior]{make_prior}, from \link[makemyprior]{makemyprior_gui}
(both with and without the "Close and run" option), from \link[makemyprior]{inference_stan}, or from \link[makemyprior]{inference_inla} (for refitting model)}

\item{use_likelihood}{Whether to sample from the prior only (FALSE, can be used for e.g. debugging or to look at the priors on variance parameters when using an HD prior), or to use the likelihood and data to get the posterior (TRUE, default).}

\item{print_prior}{Whether to print a text with the chosen prior or not (default TRUE)}

\item{...}{Other values to be sent to INLA.
Useful arguments include \code{Ntrials} for the binomial likelihood.
We set the default value of \code{num.threads} to 1 (this can however be changed).
See \link[INLA]{inla} for details.
Can be anything sent to \link[INLA]{inla} except for \code{control.expert} and arguments that specify priors.}
}
\value{
A named list with a prior object (\code{prior}), an inla-object (\code{inla}) and some data inla requires (\code{inla_data}).
}
\description{
This function helps you run inference with INLA using a prior object from \link[makemyprior]{make_prior}.
You must have INLA installed to run this. INLA can be installed with:
\code{install.packages("INLA", repos = c(getOption("repos"), INLA = "https://inla.r-inla-download.org/R/stable"), dep = TRUE)}.
Also see \href{https://www.r-inla.org/}{r-inla.org}.
}
\details{
We cannot sample from a Jeffreys' prior since it is improper.
If Jeffreys' prior is used for the total variance, the prior will be changed to a Gaussian(0,1) prior on
the log total variance. This means that it does not make sense to look at the variances/standard deviations/precisions,
but the variance proportions will be correct.
}
\examples{
\dontrun{

vignette("make_prior", package = "makemyprior")

}

ex_prior <- makemyprior_example_model()
if (interactive() && requireNamespace("INLA")){
  posterior <- inference_inla(ex_prior)
  plot(posterior)
}

}
\keyword{INLA}
