% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcalc.R
\name{mcalc}
\alias{mcalc}
\alias{mcalc<-}
\title{mcalc}
\usage{
mcalc(x, f, dim = NULL, append = FALSE)
}
\arguments{
\item{x}{MAgPIE object}

\item{f}{A formula describing the calculation that should be performed}

\item{dim}{The dimension in which the manipulation should take place. If set
to NULL function tries to detect the dimension automatically.}

\item{append}{If set to TRUE the result will be appended to x, otherwise the
result will be returned.}
}
\value{
The calculated MAgPIE object in the case that append is set to
FALSE. Otherwise nothing is returned (as x is appended in place)
}
\description{
Select values from a MAgPIE-object
}
\details{
This functions only work for MAgPIE objects with named dimensions as the
dimension name (set_name) has to be used to indicate in which dimension the
entries should be searched for!
}
\examples{

 data(population_magpie)
 population_magpie
 mcalc(population_magpie,X12 ~ A2*B1,append=TRUE)
 population_magpie
 mcalc(population_magpie,`Nearly B1` ~ 0.5*A2 + 99.5*B1)
 

}
\seealso{
\code{\link{mselect}}
}
\author{
Jan Philipp Dietrich
}
