% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-data_evaluate.R
\name{dossier_evaluate}
\alias{dossier_evaluate}
\title{Generate an assessment report of a dossier}
\usage{
dossier_evaluate(dossier, taxonomy = NULL, as_data_dict_mlstr = TRUE)
}
\arguments{
\item{dossier}{List of data frame, each of them being datasets.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}

\item{as_data_dict_mlstr}{Whether the input data dictionary should be coerced
with specific format restrictions for compatibility with other
Maelstrom Research software. TRUE by default.}
}
\value{
A list of data frames containing assessment reports.
}
\description{
Assesses the content and structure of a dossier object (list of datasets)
and generates reports of the results. This function can be used to evaluate
data structure, presence of specific fields, coherence across elements, and
data dictionary formats.
}
\details{
A dossier is a named list containing at least one data frame or more,
each of them being datasets. The name of each data frame will be use as the
reference name of the dataset.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

###### Example : a dataset list is a dossier by definition.
   
dataset <- as_dataset(
   madshapR_DEMO$`dataset_TOKYO - errors with data`,
   col_id = 'part_id') \%>\% slice(0)

dossier <- as_dossier(list(dataset = dataset))

glimpse(dossier_evaluate(dossier,as_data_dict_mlstr = FALSE))

}

}
