% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{col_id}
\alias{col_id}
\title{Return the id column names(s) of a dataset}
\usage{
col_id(dataset)
}
\arguments{
\item{dataset}{A data frame object.}
}
\value{
Name(s) of identifier column(s). NULL if not.
}
\description{
Return the id column names(s) of a dataset if any. If not, the function
returns a NULL object.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

col_id(iris)

library(fabR)
iris <- add_index(iris)
iris <- as_dataset(iris, col_id = 'index')
col_id(iris)

}

}
