% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resetMadratMessages.R
\name{resetMadratMessages}
\alias{resetMadratMessages}
\title{resetMadratMessages}
\usage{
resetMadratMessages(name = NULL, fname = NULL)
}
\arguments{
\item{name}{The category for which the messages should be reset (if not set
messages in all categories will be reset)}

\item{fname}{function name for which the entries should be reset (if not specified
messages for all function names will be reset)}
}
\description{
Delete stored madrat messages from the madrat environment. The madrat environment
behaves similar like global options, except that 1) messages will also
be stored in cache files and restored when a cache file is being loaded and
2) messages are always stored in lists with messages split by function calls
where the message was triggered.
}
\examples{
putMadratMessage("test", "This is a toast", fname = "readTau")
getMadratMessage("test", fname = "calcTauTotal")
resetMadratMessages("test")
}
\seealso{
\code{\link{putMadratMessage}}, \code{\link{getMadratMessage}}
}
\author{
Jan Philipp Dietrich
}
