% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maczic_power.R
\name{maczic_power}
\alias{maczic_power}
\title{Power Calculation for Mediation Analysis with Count and Zero-Inflated
Count Data}
\usage{
maczic_power(
  nsim,
  nsp,
  mtype,
  boot = FALSE,
  sims = 1000,
  conf.level = 0.95,
  ydist,
  size = 1,
  ymax,
  lpct0 = 0,
  hpct0 = 100,
  px1,
  am,
  bm,
  e1m,
  e2m,
  e3m,
  ag,
  bg,
  gg,
  e1g,
  e2g,
  e3g,
  delta = 0,
  ag2 = 0,
  bg2 = 0,
  gg2 = 0,
  e1g2 = 0,
  e2g2 = 0,
  e3g2 = 0,
  delta2 = 0,
  digits = 3
)
}
\arguments{
\item{nsim}{Number of simulations.}

\item{nsp}{Sample size.}

\item{mtype}{Type of mediator, either 'binary' or 'continuous'.}

\item{boot}{A logical value. if 'FALSE' a quasi-Bayesian approximation is
used for confidence intervals; if 'TRUE' nonparametric bootstrap will be
used. Default is 'FALSE'.}

\item{sims}{Number of Monte Carlo draws for nonparametric bootstrap or
quasi-Bayesian approximation. Default is 1000.}

\item{conf.level}{Level of the returned two-sided confidence intervals.
The default value, 0.95, is to return the 2.5 and 97.5 percentiles of the
simulated quantities.}

\item{ydist}{Outcome distribution. Can be 'poisson', 'negbin', 'zip', 'zinb',
or 'normal'.}

\item{size}{Dispersion parameter for negative binomial outcome distribution.
Default is 1. It's ignored for other outcome distribution.}

\item{ymax}{Maximum value of outcome allowed.}

\item{lpct0}{Low bound for percent of zeros in outcome. Default is 0.}

\item{hpct0}{High bound for percent of zeros in outcome. Default is 100.}

\item{px1}{Probability of the binary covariate being 1.}

\item{am}{User-specified value for the intercept in the mediator model.}

\item{bm}{User-specified value for the treatment coefficient in the mediator
model.}

\item{e1m}{User-specified value for the coefficient of the binary covariate
variable in the mediator model.}

\item{e2m}{User-specified value for the coefficient of the continuous
covariate variable in the mediator model.}

\item{e3m}{User-specified value for the coefficient of the multinomial
covariate variable in the mediator model.}

\item{ag}{User-specified value for the intercept in the outcome model or in
the count model of zero-inflated Poisson/Negative Binomial outcome.}

\item{bg}{User-specified value for the treatment coefficient in the outcome
model or in the count model of zero-inflated Poisson/Negative Binomial
outcome.}

\item{gg}{User-specified value for the mediator coefficient in the outcome
model or in the count model of zero-inflated Poisson/Negative Binomial
outcome.}

\item{e1g}{User-specified value for the coefficient of the binary covariate
variable in the outcome model or in the count model of zero-inflated
Poisson/Negative Binomial outcome.}

\item{e2g}{User-specified value for the coefficient of the continuous
covariate variable in the outcome model or in the count model of
zero-inflated Poisson/Negative Binomial outcome.}

\item{e3g}{User-specified value for the coefficient of the multinomial
covariate variable in the outcome model or in the count model of
zero-inflated Poisson/Negative Binomial outcome.}

\item{delta}{User-specified value for the treatment-by-mediator interaction
coefficient in the outcome model or in the count model of zero-inflated
Poisson/Negative Binomial outcome model. Default is 0.}

\item{ag2}{User-specified value for the intercept in the zero-inflation
model of zero-inflated Poisson/Negative Binomial outcome. Note that this
argument along with the following argument bg2, gg2, e1g2, e2g2, e3g2 and
delta2 only apply to zero-inflated Poisson/Negative Binomial outcome.
Default is 0.}

\item{bg2}{User-specified value for the treatment coefficient in the
zero-inflation model of zero-inflated Poisson/Negative Binomial outcome.
Default is 0.}

\item{gg2}{User-specified value for the mediator coefficient in the
zero-inflation model of zero-inflated Poisson/Negative Binomial outcome.
Default is 0.}

\item{e1g2}{User-specified value for the coefficient of the binary covariate
variable in the zero-inflation model of zero-inflated Poisson/Negative
Binomial outcome. Default is 0.}

\item{e2g2}{User-specified value for the coefficient of the continuous
covariate variable in the zero-inflation model of zero-inflated
Poisson/Negative Binomial outcome. Default is 0.}

\item{e3g2}{User-specified value for the coefficient of the multinomial
covariate variable in the zero-inflation model of zero-inflated
Poisson/Negative Binomial outcome. Default is 0.}

\item{delta2}{User-specified value for the coefficient of
treatment-by-mediator interaction in the zero-inflation model of
zero-inflated Poisson/Negative Binomial outcome. Default is 0.}

\item{digits}{Integer indicating the number of decimal places to round
the values to be returned. Default is 3.}
}
\value{
\code{maczic_power} returns a data frame with the following
  components and prints them out in a matrix format:

  \item{te.d0, te.d1}{average true mediation effects under the control and
  treatment conditions.}
  \item{te.z0, te.z1}{average true direct effects under the control and
  treatment conditions.}
  \item{te.tau}{average true total effect.}
  \item{ee.d0.rej, ee.d1.rej}{power to detect mediation effects under the
  control and treatment conditions.}
  \item{ee.z0.rej, ee.z1.rej}{power to detect direct effects under the
  control and treatment conditions.}
  \item{ee.tau.rej}{power to detect total effect.}
  \item{mean.y.z0}{mean outcome in control in the simulated data, not
  available if outcome is normal.}
  \item{mean.y.z1}{mean outcome in treatment in the simulated data, not
  available if outcome is normal.}
  \item{mean.y.gt0.z0}{mean non-zero outcome in control in the simulated
  data, not available if outcome is normal.}
  \item{mean.y.gt0.z1}{mean non-zero outcome in treatment in the simulated
  data, not available if outcome is normal}
  \item{pct0.y.z0}{mean percent zero outcome in control in the simulated
  data, not available if outcome is normal.}
  \item{pct0.y.z1}{mean percent zero outcome in treatment in the simulated
  data, not available if outcome is normal.}
}
\description{
'maczic_power' computes powers to detect average causal mediation effects
(indirect effect), average direct effects, and total effect. This function
uses simulations of 3 optional covariates (binary, normal, and
multinomial), mediator (can be binary or continuous), and outcome (can be
Normal, Poisson, Negative Binomial, zero-inflated Poisson/Negative Binomial)
based on user-specified parameter values.
}
\examples{
# For illustration purposes a small number of simulations are used
# Example 1: simulate Poisson outcome with sample size 100, binary mediator
# and 2 covariate (binary and normal) variables
posOut <- maczic_power(nsim = 8, nsp = 100,  mtype = 'binary',
                       sims = 40, ydist = "Poisson", ymax = 60,
                       px1 = 0.5, am = 0.2, bm = 0.5,
                       e1m = 0.1, e2m = 0.1, e3m = 0,
                       ag = 0.1, bg = 0.3, gg = 1,
                       e1g = 0.5, e2g = -0.2, e3g = 0, delta = 0.1)

# Example 2: simulate zero-inflated Poisson outcome with sample size 80,
# continuous mediator and 1 normal covariate variable
zipOut <-maczic_power(nsim = 5, nsp = 80, mtype = 'continuous',
                       sims=30, ydist = "zip", ymax = 88, hpct0 = 60,
                       px1 = 0.5, am = 0.1, bm = 1,
                       e1m = 0, e2m = 0.2, e3m = 0,
                       ag = 0.6, bg = 0.6, gg = 0.2, e1g = 0, e2g = -0.2,
                       e3g = 0, ag2 = -0.7, bg2 = 0.2, gg2 = 0.1,
                       e2g2 = 0.1, delta2 = 0.15)

}
\references{
Cheng, J., Cheng, N.F., Guo, Z., Gregorich, S., Ismail, A.I.,
  Gansky, S.A (2018) Mediation analysis for count and zero-inflated count
  data. Statistical Methods in Medical Research. 27(9):2756-2774.

  Tingley, D., Yamamoto, T., Hirose, K., Imai, K. and Keele, L.
  (2014). "mediation: R package for Causal Mediation Analysis", Journal of
  Statistical Software, Vol. 59, No. 5, pp. 1-38.

  Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2011). Unpacking the
  Black Box of Causality: Learning about Causal Mechanisms from Experimental
  and Observational Studies, American Political Science Review, Vol. 105, No.
  4 (November), pp. 765-789.

  Imai, K., Keele, L. and Tingley, D. (2010) A General Approach to Causal
  Mediation Analysis, Psychological Methods, Vol. 15, No. 4 (December), pp.
  309-334.

  Imai, K., Keele, L. and Yamamoto, T. (2010) Identification, Inference, and
  Sensitivity Analysis for Causal Mediation Effects, Statistical Science,
  Vol. 25, No. 1 (February), pp. 51-71.

  Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2009) "Causal Mediation
  Analysis Using R" in Advances in Social Science Research Using R, ed. H. D.
  Vinod New York: Springer.
}
\seealso{
\code{\link{mediate_zi}}
}
\author{
Nancy Cheng,
  \email{Nancy.Cheng@ucsf.edu}; Jing Cheng,
  \email{Jing.Cheng@ucsf.edu}.
}
