% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{summary.mable}
\alias{summary.mable}
\alias{summary.mable_reg}
\title{Summary mathods for classes 'mable' and 'mable_reg'}
\usage{
\method{summary}{mable}(object, ...)

\method{summary}{mable_reg}(object, ...)
}
\arguments{
\item{object}{Class "mable" or 'mable_reg' object return by \code{mable} or \code{mable.xxxx}  functions}

\item{...}{for future methods}
}
\value{
Invisibly returns its argument, \code{object}.
}
\description{
Produces a summary of a mable fit
}
\examples{
\donttest{
  # Vaal Rive Flow Data
  data(Vaal.Flow)
  res<-mable(Vaal.Flow$Flow, M=c(2,100), interval=c(0, 3000),
     controls =mable.ctrl(sig.level=1e-8, maxit=2000, eps=1.0e-9))
  summary(res)
}
\donttest{
## Breast Cosmesis Data
  require(interval)
  data(bcos)
  bcos2<-data.frame(bcos[,1:2], x=1*(bcos$treatment=="RadChem"))
  aft.res<-mable.aft(cbind(left, right)~x, data=bcos2, M=c(1, 30), tau=100, x0=1)
  summary(aft.res)
}
}
