% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand2.R
\name{expand2}
\alias{expand2}
\title{Duplicate observations within a dataframe}
\usage{
expand2(data, n_n = NULL, copies = 2, original = TRUE)
}
\arguments{
\item{data}{a data frame object}

\item{n_n}{index or indexes specifying row numbers}

\item{copies}{desired number of copies}

\item{original}{a logical indicating whether to keep the original dataframe}
}
\value{
\code{data.frame}
}
\description{
\code{expand2} generates duplicated observations within a dataframe.
}
\details{
\code{expand2} appends observations from the dataframe
with n copies of the observations with
specified indexes of observations or all data.
}
\examples{

## use infert data
data(infert)
codebook(infert)

## create duplicates
infert.new <- expand2(infert, 1:5, copies = 2)
codebook(infert.new)


## check duplicates report and rmeove dup
infert.dupremove <- duplicates(infert.new, drop = TRUE)
codebook(infert.dupremove)

## remove only 3 copies
infert.3copies <- duplicates(infert.new)
tab(infert.3copies, dup)

infert.3copies <- filter(infert.3copies, dup < 2)
codebook(infert.3copies)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
