% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.bracket.R
\name{score.bracket}
\alias{score.bracket}
\title{Compute score for bracket given actual result}
\usage{
score.bracket(bracket.empty, bracket.picks, bracket.outcome,
  bonus.round = c(1, 2, 4, 8, 16, 32), bonus.seed = rep(0, 16),
  bonus.combine = c("add", "multiply"))
}
\arguments{
\item{bracket.empty}{a length-64 character vector giving the field of 64
teams in the tournament, in order of initial overall seeding}

\item{bracket.picks}{an length-63 character vector encoding the picks
(this is the bracket to be evaluated)}

\item{bracket.outcome}{a 63-row matrix encoding the outcome of multiple
simulations of the tournament. bracket.picks will be scored against each
outcome}

\item{bonus.round}{a length-6 vector giving the number of points awarded in
your pool's scoring rules for correct picks in each round (default is
2^round)}

\item{bonus.seed}{a length-16 vector giving the bonus awarded for correctly
picking winner based on winner's seed (default is zero)}

\item{bonus.combine}{how to combine the round bonus with the seed bonus to
get the number of points awarded for each correct pick: "add" (default) or
multiply}
}
\value{
a vector giving the score for bracket.picks for each outcome in
  the matrix bracket.oucome
}
\description{
Compute score for bracket given actual result
}
\author{
sspowers
}
