% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb.R
\name{gb}
\alias{gb}
\alias{gb.}
\alias{gb_}
\alias{gb_.}
\title{Compute a Grobner basis with Macaulay2}
\usage{
gb(..., control = list(), raw_chars = FALSE, code = FALSE)

gb.(..., control = list(), raw_chars = FALSE, code = FALSE)

gb_(x, control = list(), raw_chars = FALSE, code = FALSE, ...)

gb_.(x, control = list(), raw_chars = FALSE, code = FALSE, ...)
}
\arguments{
\item{...}{...}

\item{control}{a list of options, see examples}

\item{raw_chars}{if \code{TRUE}, the character vector will not be parsed by
\code{\link[=mp]{mp()}}, saving time (default: \code{FALSE}). the down-side is that the
strings must be formated for M2 use directly, as opposed to for \code{\link[=mp]{mp()}}.
(e.g. \code{"x*y+3"} instead of \code{"x y + 3"})}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{x}{a character vector of polynomials to be parsed by \code{\link[=mp]{mp()}}, a
\code{mpolyList} object, an \code{\link[=ideal]{ideal()}} or pointer to an ideal}
}
\value{
an \code{mpolyList} object of class \code{m2_grobner_basis} or a
\code{m2_grobner_basis_pointer} pointing to the same. See \code{\link[=mpolyList]{mpolyList()}}.
}
\description{
Compute a Grobner basis with Macaulay2
}
\details{
\code{gb} uses nonstandard evaluation; \code{gb_} is the standard evaluation
equivalent.
}
\examples{

\dontrun{ requires Macaulay2


##### basic usage
########################################

# the last ring evaluated is the one used in the computation
ring("t","x","y","z", coefring = "QQ")
gb("t^4 - x", "t^3 - y", "t^2 - z")

# here's the code it's running in M2
gb("t^4 - x", "t^3 - y", "t^2 - z", code = TRUE)



##### different versions of gb
########################################

# standard evaluation version
poly_chars <- c("t^4 - x", "t^3 - y", "t^2 - z")
gb_(poly_chars)

# reference nonstandard evaluation version
gb.("t^4 - x", "t^3 - y", "t^2 - z")

# reference standard evaluation version
gb_.(poly_chars)



##### different inputs to gb
########################################

# ideals can be passed to gb
I <- ideal("t^4 - x", "t^3 - y", "t^2 - z")
gb_(I)

# note that gb() works here, too, since there is only one input
gb(I)

# ideal pointers can be passed to gb
I. <- ideal.("t^4 - x", "t^3 - y", "t^2 - z")
gb_(I.)

# setting raw_chars is a bit faster, because it doesn't use ideal()
gb("t^4 - x", "t^3 - y", "t^2 - z", raw_chars = TRUE, code = TRUE)
gb("t^4 - x", "t^3 - y", "t^2 - z", raw_chars = TRUE)



##### more advanced usage
########################################

# the control argument accepts a named list with additional
# options
gb_(
  c("t^4 - x", "t^3 - y", "t^2 - z"),
  control = list(StopWithMinimalGenerators = TRUE),
  code = TRUE
)

gb_(
  c("t^4 - x", "t^3 - y", "t^2 - z"),
  control = list(StopWithMinimalGenerators = TRUE)
)



##### potential issues
########################################

# when specifying raw_chars, be sure to add asterisks
# between variables to create monomials; that's the M2 way
ring("x", "y", "z", coefring = "QQ")
gb("x y", "x z", "x", raw_chars = TRUE, code = TRUE) # errors without code = TRUE
gb("x*y", "x*z", "x", raw_chars = TRUE, code = TRUE) # correct way
gb("x*y", "x*z", "x", raw_chars = TRUE)









}
}
\seealso{
\code{\link[=mp]{mp()}}, \code{\link[=use_ring]{use_ring()}}
}
