% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lsm.R
\name{lsm}
\alias{lsm}
\title{Latent Space Model}
\usage{
lsm(Y, D, sigma = 1, xi = 0, psi2 = 2, Niter = 100, Miniter = 10,
  tol = 0.1^2, randomZ = FALSE, nstart = 1)
}
\arguments{
\item{Y}{(\code{N} x \code{N}) binary adjacency matrix}

\item{D}{integer dimension of the latent space}

\item{sigma}{(\code{D} x \code{D}) variance/covariance matrix of the prior distribution for the latent positions. Default \code{sigma = 1}}

\item{xi}{mean of the prior distribution of \eqn{\alpha}. Default \code{xi = 0}}

\item{psi2}{variance of the prior distribution of \eqn{\alpha}. Default \code{psi2 = 2}}

\item{Niter}{maximum number of iterations. Default \code{Niter = 100}}

\item{Miniter}{minimum number of iterations. Default \code{Miniter = 10}}

\item{tol}{desired tolerance. Default \code{tol = 0.1^2}}

\item{randomZ}{logical; If \code{randomZ = TRUE} random initialization for the latent positions is used. If \code{randomZ = FALSE} and \code{D} = 2 or 3 the latent positions are initialized using the Fruchterman-Reingold method and multidimensional scaling is used for \code{D} = 1 or \code{D} > 3. Default \code{randomZ = FALSE}}

\item{nstart}{number of starts}
}
\value{
List containing:
\itemize{
\item \code{lsmEZ} (\code{N} x \code{D}) matrix containing the posterior means of the latent positions
\item \code{lsmVZ} (\code{D} x \code{D}) matrix containing the posterior variance of the latent positions
\item \code{xiT} mean of the posterior distribution of \eqn{\alpha}
\item \code{psi2T} variance of the posterior distribution of \eqn{\alpha}
\item \code{Ell} expected log-likelihood
}
}
\description{
Latent space models (LSM) are a well known family of latent variable models for network data introduced by Hoff et al. (2002) under the basic assumption that each node has an unknown position in a D-dimensional Euclidean latent space: generally the smaller the distance between two nodes in the latent space, the greater the probability of them being connected. Unfortunately, the posterior distribution of the LSM cannot be computed analytically. For this reason we propose a variational inferential approach which proves to be less computationally intensive than the MCMC procedure proposed in Hoff et al. (2002) (implemented in the \code{latentnet} package) and can therefore easily handle large networks.
Salter-Townshend and Murphy (2013) applied variational methods to fit the LSM with the Euclidean distance in the \code{VBLPCM} package.
In this package, a distance model with squared Euclidean distance is used. We follow the notation of Gollini and Murphy (2014).
}
\examples{
### Simulate Undirected Network
N <- 20
Y <- network(N, directed = FALSE)[,]

modLSM <- lsm(Y, D = 2)
plot(modLSM, Y)
}
\references{
Gollini, I., and Murphy, T. B. (2014), "Joint Modelling of Multiple Network Views", Journal of Computational and Graphical Statistics \url{http://arxiv.org/abs/1301.3759}.

Hoff, P., Raftery, A., and Handcock, M. (2002), "Latent Space Approaches to Social Network Analysis", Journal of the American Statistical Association, 97, 1090--1098.
}
\seealso{
\code{\link{plot.lsm}}
}

