% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ctx}
\alias{ctx}
\title{Context object}
\description{
Context objects used in luz to share information between model methods,
metrics and callbacks.
}
\details{
The \code{ctx} object is used in luz to share information between the
training loop and callbacks, model methods, and metrics. The table below
describes information available in the \code{ctx} by default. Other callbacks
could potentially modify these attributes or add new ones.\if{html}{\out{
<!-- It's recommended to use the RStudio Visual editor to edit this table. -->
}}
\tabular{ll}{
   Attribute \tab Description \cr
   \code{verbose} \tab The value (\code{TRUE} or \code{FALSE}) attributed to the \code{verbose} argument in \code{fit} . \cr
   \code{accelerator} \tab Accelerator object used to query the correct device to place models, data, etc. It assumes the value passed to the \code{accelerator} parameter in \code{fit}. \cr
   \code{model} \tab Initialized \code{nn_module} object that will be trained during the \code{fit} procedure. \cr
   \code{optimizers} \tab A named list of optimizers used during training. \cr
   \code{data} \tab The currently in-use dataloader. When training it’s \code{ctx$train_data}, when doing validation its \code{ctx$valid_data}. It can also be the prediction dataset when in \code{predict}. \cr
   \code{train_data} \tab Dataloader passed to the \code{data} argument in \code{fit}. Modified to yield data in the selected device. \cr
   \code{valid_data} \tab Dataloader passed to the \code{valid_data} argument in \code{fit}. Modified to yield data in the selected device. \cr
   \code{min_epochs} \tab Minimum number of epochs the model will be trained for. \cr
   \code{max_epochs} \tab Maximum number of epochs the model will be trained for. \cr
   \code{epoch} \tab Current training epoch. \cr
   \code{iter} \tab Current training iteration. It’s reset every epoch and when going from training to validation. \cr
   \code{training} \tab Whether the model is in training or validation mode. See also \code{help("luz_callback_train_valid")} \cr
   \code{callbacks} \tab List of callbacks that will be called during the training procedure. It’s the union of the list passed to the \code{callbacks} parameter and the default \code{callbacks}. \cr
   \code{step} \tab Closure that will be used to do one \code{step} of the model. It’s used for both training and validation. Takes no argument, but can access the \code{ctx} object. \cr
   \code{call_callbacks} \tab Call callbacks by name. For example \code{call_callbacks("on_train_begin")} will call all callbacks that provide methods for this point. \cr
   \code{batch} \tab Last batch obtained by the dataloader. A batch is a \code{list()} with 2 elements, one that is used as \code{input} and the other as \code{target}. \cr
   \code{input} \tab First element of the last batch obtained by the current dataloader. \cr
   \code{target} \tab Second element of the last batch obtained by the current dataloader. \cr
   \code{pred} \tab Last predictions obtained by \code{ctx$model$forward} . \strong{Note:} can be potentially modified by previously ran callbacks. Also note that this might not be available if you used a custom training step. \cr
   \code{loss_fn} \tab The active loss function that will be minimized during training. \cr
   \code{loss} \tab Last computed loss from the model. \strong{Note:} this might not be available if you modified the training or validation step. \cr
   \code{opt} \tab Current optimizer, ie. the optimizer that will be used to do the next \code{step} to update parameters. \cr
   \code{opt_nm} \tab Current optimizer name. By default it’s \code{opt} , but can change if your model uses more than one optimizer depending on the set of parameters being optimized. \cr
   \code{metrics} \tab \code{list()} with current metric objects that are \code{update}d at every \code{on_train_batch_end()} or \code{on_valid_batch_end()}. See also \code{help("luz_callback_metrics")} \cr
   \code{records} \tab \code{list()} recording metric values for training and validation for each epoch. See also \code{help("luz_callback_metrics")} . Also records profiling metrics. See \code{help("luz_callback_profile")} for more information. \cr
   \code{handlers} \tab A named \code{list()} of handlers that is passed to \code{rlang::with_handlers()} during the training loop and can be used to handle errors or conditions that might be raised by other callbacks. \cr
   \code{epoch_handlers} \tab A named list of handlers that is used with \code{rlang::with_handlers()}. Those handlers are used inside the epochs loop, thus you can handle epoch specific conditions, that won’t necessarily end training. \cr
}


Context attributes
}
\seealso{
Context object: \link{context}
}
