% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict.PredictiveModelList}
\alias{predict,PredictiveModelList-method}
\alias{predict.PredictiveModelList}
\title{Predict location suitability}
\usage{
\method{predict}{PredictiveModelList}(object, newdata, data.frame = FALSE,
  ...)

\S4method{predict}{PredictiveModelList}(object, newdata, data.frame = FALSE,
  ...)
}
\arguments{
\item{object}{a PredictiveModelList object}

\item{newdata}{data.frame containing new data}

\item{data.frame}{logical indicating whether the function should return a
matrix (default) or data.frame}

\item{\dots}{additional arguments to \code{predict} methods}
}
\value{
A matrix.
}
\description{
Estimate location suitability with predictive models.
}
\details{
This function is usually called from \code{allocate} to calculate land use
suitability at each timestep. However, it may also be used to produce
suitability maps (see examples).
}
\examples{
\dontrun{

## Sibuyan Island

## load observed land use data
obs <- ObsLulcRasterStack(x=sibuyan$maps,
                    pattern="lu",
                    categories=c(1,2,3,4,5),
                    labels=c("Forest","Coconut","Grass","Rice","Other"),
                    t=c(0,14))

## load explanatory variables
ef <- ExpVarRasterList(x=sibuyan$maps, pattern="ef")

## separate data into training and testing partitions
part <- partition(x=obs[[1]], size=0.1, spatial=TRUE)
train.data <- getPredictiveModelInputData(obs=obs, ef=ef, cells=part[["train"]])
all.data <- getPredictiveModelInputData(obs=obs, ef=ef, cells=part[["all"]])

## get glm.models from data
forms <- list(Forest ~ ef_001+ef_002+ef_003+ef_004+ef_005+ef_006+ef_007+ef_008+ef_010+ef_012,
              Coconut ~ ef_001+ef_002+ef_005+ef_007+ef_008+ef_009+ef_010+ef_011+ef_012,
              Grass~ef_001+ef_002+ef_004+ef_005+ef_007+ef_008+ef_009+ef_010+ef_011+ef_012+ef_013,
              Rice~ef_009+ef_010+ef_011,
              Other~1)

glm.models <- glmModels(formula=forms, family=binomial, data=train.data, obs=obs)

## create suitability maps
suitability.maps <- predict(object=glm.models, newdata=all.data, data.frame=TRUE)
points <- rasterToPoints(obs[[1]], spatial=TRUE)
suitability.maps <- SpatialPointsDataFrame(coords=points, data=suitability.maps)
r <- stack(rasterize(x=suitability.maps, y=obs[[1]], field=names(suitability.maps)))
plot(r)

## library(rasterVis)
## levelplot(r)

}
}
\seealso{
\code{\link{Model fitting}}, \code{\link{allocate}}
}

