% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{errorSpent}
\alias{errorSpent}
\title{Error spending}
\usage{
errorSpent(t, error, sf = "sfOF", sfpar = NA)
}
\arguments{
\item{t}{A vector of spending times, typically equal to information
fractions.}

\item{error}{The total error to spend.}

\item{sf}{The spending function. One of the following: "sfOF" for
O'Brien-Fleming type spending function, "sfP" for Pocock type spending
function, "sfKD" for Kim & DeMets spending function, and "sfHSD" for
Hwang, Shi & DeCani spending function. Defaults to "sfOF".}

\item{sfpar}{The parameter for the spending function. Corresponds to
rho for "sfKD" and gamma for "sfHSD".}
}
\value{
A vector of errors spent up to the interim look.
}
\description{
Obtains the error spent at given spending times
for the specified error spending function.
}
\examples{
errorSpent(t = 0.5, error = 0.025, sf = "sfOF")
errorSpent(t = c(0.5, 0.75, 1), error = 0.025, sf = "sfHSD", sfpar = -4)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
