% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{zstatRiskDiff}
\alias{zstatRiskDiff}
\title{Miettinen-Nurminen Score Test Statistic for Two-Sample Risk
difference}
\usage{
zstatRiskDiff(
  riskDiffH0 = 0,
  n1 = NA_real_,
  y1 = NA_real_,
  n2 = NA_real_,
  y2 = NA_real_
)
}
\arguments{
\item{riskDiffH0}{The risk difference under the null hypothesis.
Defaults to 0.}

\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}
}
\value{
The value of the score test statistic.
}
\description{
Obtains the Miettinen-Nurminen score test statistic
for two-sample risk difference possibly with stratification.
}
\details{
The Mantel-Haenszel sample size weights are used for stratified
samples.
}
\examples{

zstatRiskDiff(riskDiffH0 = 0, n1 = c(10,10), y1 = c(4,3),
              n2 = c(20,10), y2 = c(2,0))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
