% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_header_item.R
\name{set_header_item}
\alias{set_header_item}
\title{Set information in an LPJmL input (or output) file header}
\usage{
set_header_item(header, ...)
}
\arguments{
\item{header}{An LPJmL file header as returned by \code{\link[=read_header]{read_header()}} or
\code{\link[=create_header]{create_header()}}.}

\item{...}{Named header items to set. Can be one or several of 'name',
'version', 'order', 'firstyear', 'nyear', 'firstcell', 'ncell', 'nbands',
'cellsize_lon', 'scalar', 'cellsize_lat', 'datatype', 'nstep', 'timestep',
'endian'. Parameter 'verbose' can be used to control verbosity, as in
\code{\link[=create_header]{create_header()}}.}
}
\value{
Header \code{header} where header items supplied through the ellipsis
have been changed.
}
\description{
Convenience function to set information in a header object as
returned by \code{\link[=read_header]{read_header()}} or \code{\link[=create_header]{create_header()}}. One or several
}
\examples{
header <- create_header(
  name = "LPJGRID",
  version = 3,
  order = 1,
  firstyear = 1901,
  nyear = 1,
  firstcell = 0,
  ncell = 67420,
  nbands = 2,
  cellsize_lon = 0.5,
  scalar = 1.0,
  cellsize_lat = 0.5,
  datatype = 3,
  nstep = 1,
  timestep = 1,
  endian = .Platform$endian,
  verbose = TRUE
)

header
# $name
# [1] "LPJGRID"
#
# $header
#      version        order    firstyear        nyear    firstcell        ncell
#          3.0          1.0       1901.0          1.0          0.0      67420.0
#        nbands cellsize_lon       scalar cellsize_lat     datatype       nstep
#          2.0          0.5          1.0          0.5          3.0          1.0
#     timestep
#          1.0
#
# $endian
# [1] "little"

# Change number of cells to 1
set_header_item(header = header, ncell = 1)
# $name
# [1] "LPJGRID"
#
# $header
#      version        order    firstyear        nyear    firstcell        ncell
#          3.0          1.0       1901.0          1.0          0.0          1.0
#        nbands cellsize_lon       scalar cellsize_lat     datatype       nstep
#          2.0          0.5          1.0          0.5          3.0          1.0
#     timestep
#          1.0
#
# $endian
# [1] "little"

}
\seealso{
\itemize{
\item \code{\link[=create_header]{create_header()}} for creating headers from scratch and for a more
detailed description of the LPJmL header format.
\item \code{\link[=read_header]{read_header()}} for reading headers from files.
}
}
