% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{null_model}
\alias{null_model}
\title{null_model}
\usage{
null_model(Y, lambda2, cov = NULL, thresh = 1e-06, maxit = 1000,
  trace.it = F)
}
\arguments{
\item{Y}{nxp count matrix}

\item{lambda2}{regularization parameter}

\item{cov}{npxK matrix of covariates}

\item{thresh}{convergence threshold}

\item{maxit}{maximum number of iterations}

\item{trace.it}{boolean indicating whether information about convergence should be displayed}
}
\value{
A list with the following elements
\item{X}{nxp matrix of log of expected counts}
\item{mu}{intercept}
\item{alpha}{coefficients of covariates}
}
\description{
null_model
}
\examples{
\dontshow{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- null_model(Y, 10, X)
}
}
