% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_move.R
\name{l_move_grid}
\alias{l_move_grid}
\title{Arrange Points or Nodes on a Grid}
\usage{
l_move_grid(widget, which = "selected")
}
\arguments{
\item{widget}{plot or graph widget handle or widget path name}

\item{which}{either one of \code{'selected'}, \code{'active'}, \code{'all'}, 
or a boolean vector with a value for each point.}
}
\description{
Scatterplot and graph displays support interactive temporary 
  relocation of single points (nodes for graphs).
}
\details{
Moving the points temporarily saves the new point coordinates to the
  states \code{xTemp} and \code{yTemp}. The dimension of \code{xTemp} and 
  \code{yTemp} is either \code{0} or \code{n}. If \code{xTemp} or 
  \code{yTemp} are not of length \code{0} then they are required to be of 
  length \code{n}, and the scatterplot will display those coordinates instead
  of the coordinates in \code{x} or \code{y}.
  
  Note that the points can also be temporally relocated using mouse and 
  keyboard gestures. That is, to move a single point or node press the 
  \code{CTRL} key wile dragging a the point. To move the selected points 
  press down the \code{CTRL} and \code{Shift} keys while dragging one of the 
  selected points.
  
  When distributing points horizontally or vertically, their order remains 
  the same. When distributing points horizontally or vertically, their order 
  remains the same. For example, when you distribute the point both 
  horizontally and vertically, then the resulting scatterplot will be a plot 
  of the \code{y} ranks versus the \code{x} ranks. The correlation on that 
  plot will be Spearman's rho. When arranging points on a grid, some of the 
  spatial ordering is preserved by first determining a grid size (i.e. 
  \code{a x b} where \code{a} and \code{b} are the same or close numbers) and
  then by taking the \code{a} smallest values in the \code{y} direction and
  arrange them by their \code{x} order in the first row, then repeat for the
  remaining points.
  
  Also note the the loon inspector also has buttons for these temporary 
  points/nodes movements.
}
\seealso{
\code{\link{l_move_valign}}, \code{\link{l_move_halign}},
  \code{\link{l_move_vdist}}, \code{\link{l_move_hdist}},
  \code{\link{l_move_grid}}, \code{\link{l_move_jitter}},
  \code{\link{l_move_reset}}
}
