% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{r_dtrunc_elife}
\alias{r_dtrunc_elife}
\title{Sample observations from an interval truncated excess lifetime distribution}
\usage{
r_dtrunc_elife(
  n,
  scale,
  rate,
  shape,
  lower,
  upper,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake")
)
}
\arguments{
\item{n}{sample size}

\item{scale}{scale parameter(s)}

\item{rate}{rate parameter(s)}

\item{shape}{shape parameter(s)}

\item{lower}{vector of lower bounds}

\item{upper}{vector of upper bounds}

\item{family}{string; choice of parametric family}
}
\value{
a vector of \code{n} observations
}
\description{
Sample observations from an interval truncated excess lifetime distribution
}
\examples{
n <- 100L
# the lower and upper bound are either scalar,
# or else vectors of length n
r_dtrunc_elife(n = n, scale = 1, shape = -0.1,
               lower = pmax(0, runif(n, -0.5, 1)),
               upper = runif(n, 6, 10),
               family = "gp")
}
\keyword{internal}
