% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{get_warnings}
\alias{get_warnings}
\title{Gets warnings from most recent log}
\usage{
get_warnings()
}
\description{
Returns a vector of warning messages from the most recent
logging session.  The function takes no parameters.  The warning
list will be cleared the next time \code{\link{log_open}} is called.
}
\examples{
library(logr)

# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send warning message to log
log_warning("Here is a warning")

# Close log
log_close()

# Retrieve warnings
res <- get_warnings()

# View results
res
# [1] "Warning: Here is a warning"
}
\seealso{
\code{\link{log_warning}} to write a warning message to the log.
}
