% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_experiment.R
\name{create_experiment}
\alias{create_experiment}
\title{Create a NetLogo BehaviorSpace experiment XML file}
\usage{
create_experiment(
  name = "",
  repetitions = 1,
  sequential_run_order = TRUE,
  run_metrics_every_step = FALSE,
  pre_experiment = NULL,
  setup = "setup",
  go = "go",
  post_run = NULL,
  post_experiment = NULL,
  time_limit = 1,
  exit_condition = NULL,
  metrics = c("count turtles", "count patches"),
  run_metrics_condition = NULL,
  constants = NULL
)
}
\arguments{
\item{name}{(optional) A string specifying the name of the experiment
(default: \code{""}).}

\item{repetitions}{(optional) An integer number specifying the number of
times to repeat the experiment (default: \code{1}).}

\item{sequential_run_order}{(optional) A \code{\link[=logical]{logical}} flag
indicating whether to run the experiments in sequential order
(default: \code{TRUE}).}

\item{run_metrics_every_step}{(optional) A \code{\link[=logical]{logical}} flag
indicating whether to record metrics at every step (default: \code{FALSE}).}

\item{pre_experiment}{(optional) A string specifying the NetLogo command to
run before the experiment starts (default: \code{NULL}).}

\item{setup}{A string specifying the NetLogo command to set up the model
(default: \code{"setup"}).}

\item{go}{A string specifying the NetLogo command to run the model
(default: \code{"go"}).}

\item{post_run}{(optional) A string specifying the NetLogo command to run
after each run (default: \code{NULL}).}

\item{post_experiment}{(optional) A string specifying the NetLogo command
to run after the experiment ends (default: \code{NULL}).}

\item{time_limit}{(optional) An integer number specifying the maximum number
of steps to run for each repetition (default: \code{1}).}

\item{exit_condition}{(optional) A string specifying the NetLogo command
that defines the exit condition for the experiment (default: \code{NULL}).}

\item{metrics}{A \code{\link[=character]{character}} vector specifying the NetLogo
commands to record as metrics
(default: \code{c('count turtles', 'count patches')}).}

\item{run_metrics_condition}{(optional) A string specifying the NetLogo
command that defines the condition to record metrics (default: \code{NULL}).}

\item{constants}{(optional) A named \code{\link[=list]{list}} specifying the constants
to vary in the experiment. Each element can be either a single value (for
enumerated values) or a \code{\link[=list]{list}} with \code{first}, \code{step}, and \code{last}
elements (for stepped values). See the \emph{Details} and  \emph{Examples} sections
to learn more (default: \code{NULL}).}
}
\value{
A string with the path to the created XML file.
}
\description{
\code{create_experiment()} creates a NetLogo BehaviorSpace experiment XML in a
temporary file that can be used to run headless experiments with the
\code{\link[=run_experiment]{run_experiment()}} function.

Please refer to the
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace Guide} for
complete guidance on how to set and run experiments in NetLogo.
}
\details{
\subsection{Constants}{

The \code{constants} argument allows you to specify the parameters to vary in the
experiment. It should be a named \code{\link[=list]{list}} where each name corresponds
to a NetLogo variable. The value for each name can be either:
\itemize{
\item A single value (for enumerated values). For example, to set the variable
\code{initial-number-of-turtles} to \code{10}, you would use
\code{list("initial-number-of-turtles" = 10)}.
\item A \code{\link[=list]{list}} with \code{first}, \code{step}, and \code{last} elements (for stepped
values). For example, to vary the variable \code{initial-number-of-turtles} from
\code{10} to \code{50} in steps of \code{10}, you would use
\code{list("initial-number-of-turtles" = list(first = 10, step = 10, last = 50))}.
}

Please note that any mistake in the constants names will cause the experiment
to return an empty result set. Be careful when changing them.

Also, enclose commands with single quotes (e.g., \code{'n-values 10 ["N/A"]'}),
since NetLogo only accepts double quotes for strings.
}
}
\examples{
setup_file <- create_experiment(
  name = "Wolf Sheep Simple Model Analysis",
  repetitions = 10,
  sequential_run_order = TRUE,
  run_metrics_every_step = TRUE,
  setup = "setup",
  go = "go",
  time_limit = 1000,
  metrics = c(
    'count wolves',
    'count sheep'
  ),
  run_metrics_condition = NULL,
  constants = list(
    "number-of-sheep" = 500,
    "number-of-wolves" = list(
      first = 5,
      step = 1,
      last = 15
    ),
    "movement-cost" = 0.5,
    "grass-regrowth-rate" = 0.3,
    "energy-gain-from-grass" = 2,
    "energy-gain-from-sheep" = 5
  )
)

setup_file

setup_file |> inspect_experiment_file()
}
\seealso{
Other NetLogo functions: 
\code{\link{run_experiment}()}
}
\concept{NetLogo functions}
