% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticRR.R
\name{printRR}
\alias{printRR}
\title{Print adjusted relative risk under binary or ordinal exposure variable.}
\usage{
printRR(formula, basecov = 0, fixcov = NULL, data)
}
\arguments{
\item{formula}{a formula term that is passed into \code{glm()} having a form of \code{response ~ terms} where \code{response} is binary response vector and \code{terms} is a collection of terms connected by \code{'+'}. The first term of predictors will be used as a predictor of interest to calculate relative risks with respect to response variable.}

\item{basecov}{a baseline value of exposure variable. Defaults to \code{0}.}

\item{fixcov}{a data frame of fixed value for each of adjusted confounders. If there is no confounder other than an exposure variable of interest, \code{fixcov} = \code{NULL}; if \code{fixcov} is missing for covariates, they are all set to \code{0} (for numerical covariates) or first levels (for factor covariates).}

\item{data}{a data frame containing response variable and all the terms used in \code{formula}.}
}
\value{
\item{\code{fit}}{an object of class \code{glm}.}
\item{\code{RR}}{(adjusted) relative risk in response under exposure at baseline (\code{basecov}) and \code{basecov + 1}.}
\item{\code{delta.var}}{estimated variance of relative risk (\code{RR}) using Delta method.}
\item{\code{fix.cov}}{a data frame of fixed value for each of adjsuted confounders.}
}
\description{
Print adjusted relative risk under binary or ordinal exposure variable.
}
\examples{
n <- 500
set.seed(1234)
X <- rbinom(n, 1, 0.3)
W <- rbinom(n, 1, 0.3)
W[sample(1:n, n/3)] = 2
Y <- rbinom(n, 1, plogis(X - W))
dat <- as.data.frame(cbind(Y, X, W))
result <- printRR(Y ~ X + W, basecov = 0, data = dat)

}
