% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analysis}
\alias{analysis}
\title{Run a Salary Analysis}
\usage{
analysis(
  data,
  reference_month,
  reference_year,
  female_spec = "F",
  male_spec = "M",
  age_spec = NULL,
  entry_date_spec = NULL,
  ignore_plausibility_check = FALSE,
  prompt_data_cleanup = FALSE
)
}
\arguments{
\item{data}{a data.frame of employees as produced by \code{read_data}}

\item{reference_month}{an integer representing the reference month, i.e. the
month for which we analyze the salaries}

\item{reference_year}{an integer representing the reference year, i.e. the
year for which we analyze the salaries}

\item{female_spec}{an optional string or numeric representing the way women
are encoded in the \code{data}}

\item{male_spec}{an optional string or numeric representing the way men are
encoded in the \code{data}}

\item{age_spec}{an optional string to specify the way \code{age} is encoded
in the data (\code{NULL} will try to automatically infer the age format,
\code{"age"} implies that the \code{age} is specified as the age of a person,
\code{"birthyear"} implies that the \code{age} is specified as the year of
birth of a person, and \code{"birthdate"} implies that the \code{age} is
specified as the date of birth of a person)}

\item{entry_date_spec}{an optional string to specify the way
\code{entry_date} is encoded in the data (\code{NULL} will try to
automatically infer the format, \code{"years"} implies that the
\code{entry_date} is specified as the number of years for which the person
has been in the company, \code{"entry_year"} implies that the
\code{entry_date} is specified as the year of the entry date of the person,
\code{"entry_date"} implies that the age is specified as the date of entry
of the person)}

\item{ignore_plausibility_check}{a boolean indicating whether the
plausibility of the data should be checked or whether all correct data is
considered plausible}

\item{prompt_data_cleanup}{a boolean indicating whether a prompt will pop up
to enforce cleaning the data until all data is correct}
}
\value{
object of type \code{analysis_model} with the following
elements
\itemize{
   \item{\code{params}: }{The set of original parameters passed to the
   function}
   \item{\code{data_original}: }{The original data passed by the user in the
   \code{data} parameter}
   \item{\code{data_clean}: }{The cleaned up data which was used for the
   analysis}
   \item{\code{data_errors}: }{The list of errors which were found upon
   checking the data}
   \item{\code{results}: }{The result of the standard analysis model}

}
}
\description{
Runs a salary analysis according to the Swiss standard analysis model
}
\examples{
results <- analysis(data = datalist_imprimerie, reference_month = 1,
   reference_year = 2019, female_spec = 1, male_spec = 2)

}
