## ----include = FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
old <- options(width = 200)

## ----setup, include = FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(loggit2)

## ----handlers_0, eval = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(loggit2)
#  
#  set_logfile("/path/to/my/log/directory/loggit.log") # loggit2 enforces no specific file extension

## ----handlers, error = TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
message("This is a message")
warning("This is a warning")
stop("This is a critical error")

## ----loggit2_func-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit("INFO", "This is also a message")
loggit("WARN", "This is also a warning")
loggit("ERROR", "This is an error, but it won't stop")

## ----custom_fields------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit(
  "INFO",
  "This is a message",
  but_maybe = "you want more fields?",
  sure = "why not?",
  like = 2
)

## ----read_logs----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
read_logs()

## ----include = FALSE----------------------------------------------------------
options(old)

