% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_pluginBw.R
\name{h_pluginBw}
\alias{h_pluginBw}
\title{Quantile-based bandwidth selectors based on the plug-in bandwidth
selector for mean regression}
\usage{
h_pluginBw(X, Y, p = 1, kernel = gaussK, omega)
}
\arguments{
\item{X}{The covariate data values.}

\item{Y}{The response data values.}

\item{p}{The order of the local polynomial estimator. In default setting,
\code{p=1}.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}
}
\value{
\code{\link{h_pluginBw}} provides the quantile-based bandwidth
based on the plugin bandwidth selector for mean regression proposed by
Fan and Gijbels (1996) as discussed in Adam and Gijbels (2021a).
}
\description{
Quantile-based bandwidth selector for univariate expectile regression
based on the plug-in bandwidth selector proposed by Fan and Gijbels
(1996).
}
\examples{
library(locpol)
data(mcycle)
y=mcycle$accel
x=mcycle$times

h=h_pluginBw(X=x,Y=y,p=1,kernel=gaussK,omega=0.1)
#h=0.8602156

}
\references{
{
Fan, J. and Gijbels, I. (1996). Local Polynomial Modelling and Its
Applications. Number 66 in Monographs on statistics and applied probability
series. Chapman and Hall, London.

Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.

}
}
