% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemma_chat_template.R
\name{apply_gemma_chat_template}
\alias{apply_gemma_chat_template}
\title{Apply Gemma-Compatible Chat Template}
\usage{
apply_gemma_chat_template(messages, add_assistant = TRUE)
}
\arguments{
\item{messages}{A list of message objects, each with 'role' and 'content' fields}

\item{add_assistant}{Whether to add the assistant turn prefix (default: TRUE)}
}
\value{
A character string with properly formatted Gemma chat template
}
\description{
Creates a properly formatted chat template for Gemma models, which use
<start_of_turn> and <end_of_turn> markers instead of ChatML format.
This function addresses compatibility issues with apply_chat_template()
when used with Gemma models.
}
\examples{
\dontrun{
messages <- list(
  list(role = "system", content = "You are a helpful assistant."),
  list(role = "user", content = "Hello!")
)
formatted <- apply_gemma_chat_template(messages)
}
}
