% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_mte.R
\name{eval_mte}
\alias{eval_mte}
\title{Evaluate Marginal Treatment Effects from a Fitted MTE Model.}
\usage{
eval_mte(object, x = colMeans(object$X)[-1], u)
}
\arguments{
\item{object}{An object of class \code{mte} returned by \code{\link{mte}}.}

\item{x}{A set of pretreatment covariates at which MTE(x, u) is evaluated. Default
is the sample means.}

\item{u}{Value(s) of the latent resistance \eqn{u} at which MTE(x, u) is evaluated.}
}
\value{
A list of three elements.
  \item{mte}{Estimates of MTE(x, u)}
  \item{x_comp}{Estimates of \eqn{\mu_1(x)-\mu_0(x)}}
  \item{u_comp}{Estimates of \eqn{E[\eta|U=u]}}
}
\description{
\code{eval_mte} is a function that evaluates marginal treatment effects at any
combination of covariates \code{x} and latent resistance \code{u} from a fitted
\code{mte} object. Note that the estimation may involve substantial extrapolation
when the propensity score has a limited support.
}
\examples{
mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x,
  method = "localIV", data = toydata)

# plot MTE(x, u) as a function of u
u <- seq(0.005, 0.995, 0.01)
out <- eval_mte(mte_fit, u = u)
plot(out$mte ~ u, type = "l", lwd = 2)

}
