% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qua.R
\name{qua}
\alias{qua}
\title{Generic function for \code{qua...}: probabilily distribution fitting with L-Moments}
\usage{
qua(
  para,
  f,
  probability_distribution_attrname = "probability_distrib",
  distrib = NA,
  ...
)
}
\arguments{
\item{f, para, ...}{L-moments and further parameters for \code{qua...}}

\item{probability_distribution_attrname}{attribute name for probability distribution}

\item{distrib}{character string indicating the probability distribution, it can be used in case \code{para} has no attributes. Default is \code{NA} and distribution info are all passed through \code{para}.}
}
\value{
A vector of quantiles. It is a list of vectors of quantiles in case of several probability parametric distribution functions (i.e. \code{para} is a list and \code{length(para)>1}).
}
\description{
Generic function for \code{qua...}: probabilily distribution fitting with L-Moments
}
\examples{

# Sample L-moments of Ozone from the airquality data
data(airquality)
lmom <- samlmu(airquality$Ozone,nmom=6)

distrib <- c("exp","gam","gev","glo","gpa","gno","gum","kap","ln3","nor",
	"pe3","wak","wei")

para_list <- pel(distrib=distrib,lmom=lmom)
f <- (1:10)/10
qua_list <- qua(para=para_list,f=f)

qua_gam <- qua(para=para_list$gam,f=f)
qua_gam2 <- qua(para=as.vector(para_list$gam),f=f,distrib="gam")

if (any(qua_gam!=qua_gam2,na.rm=TRUE)) stop("Any possible errors after  0.6.3 package updates!") 


}
\seealso{
\code{\link{pel}},\code{\link{quaexp}},\code{\link{quagam}},\code{\link{quagev}},\code{\link{quaglo}},\code{\link{quagpa}},\code{\link{quagno}},\code{\link{quagum}},

\code{\link{quakap}},\code{\link{qualn3}},\code{\link{quanor}},\code{\link{quape3}},
\code{\link{quawak}},\code{\link{quawei}}
}
