% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mru.R
\name{plot.mru}
\alias{plot.mru}
\title{plots the results of a
multinomial restricted unfolding}
\usage{
\method{plot}{mru}(
  x,
  dims = c(1, 2),
  ynames = NULL,
  ycol = "darkgreen",
  xcol = "lightskyblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type mru}

\item{dims}{which dimensions to visualize}

\item{ynames}{names of the response variables}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from mru
}
\description{
plots the results of a
multinomial restricted unfolding
}
\examples{
data(dataExample_mru)
y = as.matrix(dataExample_mru[1:20 , 1])
X = as.matrix(dataExample_mru[1:20 , 2:6])
output = mru(y = y, X = X, S = 2)
plot(output)

}
