% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estfun.R
\name{estfun}
\alias{estfun}
\alias{estfun.Bernoulli}
\alias{estfun.GP}
\title{Functions for the \code{estfun} method}
\usage{
\method{estfun}{Bernoulli}(x, ...)

\method{estfun}{GP}(x, eps = 1e-05, m = 3, ...)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{Further arguments.  None are used for
\code{estfun.Bernoulli} or \code{estfun.GP}.}

\item{eps, m}{These control the estimation of the observed
information in \code{gpObsInfo} when the GP shape parameter \eqn{\xi} is
very close to zero.  In these cases, direct calculation is unreliable.
\code{eps} is a (small, positive) numeric scalar.  If the absolute value
of the input value of \eqn{\xi}, that is, \code{pars[2]}, is smaller than
\code{eps} then we approximate the \code{[2, 2]} element using a Taylor
series expansion in \eqn{\xi}, evaluated up to and including the
\code{m}th term.}
}
\value{
An \eqn{n \times k}{n x k} matrix containing contributions
  to the score function from \eqn{n} observations for each of the \eqn{k}
  parameters.

  \code{estfun.Bernoulli}: an \eqn{n \times 2}{n x 1} matrix, where
  \eqn{n} is the sample size, the length of the input \code{data} to
  \code{\link{fitBernoulli}}.  The column is named \code{prob}.

  \code{estfun.GP}: an \eqn{n \times 2}{n x 2} matrix, where \eqn{n} is the
  sample size, the length of the input \code{data} to \code{\link{fitGP}}.
  The columns are named \code{sigma[u]} and \code{xi}
}
\description{
Functions to calculate contributions to the score vector from individual
observations for a fitted model object.
}
\details{
An \code{\link[sandwich]{estfun}} method is used by
  \code{\link[sandwich:vcovCL]{meatCL}} to calculate the
  \code{\link[sandwich]{meat}} in the sandwich covariance estimator on which
  the log-likelihood adjustments in \code{\link{flite}} are based.
  Specifically, \code{\link[sandwich:vcovCL]{meatCL}} is used to calculate
  the argument \code{V} passed to \code{\link[chandwich]{adjust_loglik}}.
}
\examples{
library(sandwich)

# estfun.Bernoulli
bfit <- fitBernoulli(c(exdex::cheeseboro) > 45)
head(estfun(bfit))

# estfun.generalisedPareto
gpfit <- fitGP(c(exdex::cheeseboro), u = 45)
head(estfun(gpfit))
}
\seealso{
\code{\link{Bernoulli}} for maximum likelihood inference for the
  Bernoulli distribution.

\code{\link{generalisedPareto}} for maximum likelihood inference
  for the generalised Pareto distribution.
}
