% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-utils.R
\name{list_depth}
\alias{list_depth}
\title{Get the depth of a list}
\usage{
list_depth(l, prune_empty_elts = FALSE)
}
\arguments{
\item{l}{A variable, probably a list.}

\item{prune_empty_elts}{A logical value.  Should empty elements be pruned
without counting them?}
}
\value{
A non-negative integer of the deepest depth of the list.
}
\description{
Gets the depth of a list (at its deepest point).
}
\examples{
list_depth(list(1))
list_depth(list(1, list(2:3, 4:6)))

# Atomic variables have depth 0
list_depth(1)

# Empty elements can be pruned before counting
list_depth(list())
list_depth(list(), prune_empty_elts = TRUE)
}
\seealso{
This is loosely based upon \code{list.depth} (internal to older
versions of the \code{Zelig} package), but gives different answers.
}

