% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lst.R
\name{gen_list}
\alias{gen_list}
\title{List comprehensions}
\usage{
gen_list(element_expr, ..., .compile = TRUE)
}
\arguments{
\item{element_expr}{an expression that will be collected}

\item{...}{either a logical expression that returns a length 1 result.
A named list of equal length sequences that are iterated over
in parallel or a named parameter with an iterable sequence.}

\item{.compile}{compile the resulting for loop to bytecode befor eval}
}
\value{
A list of all generated values. The element-type is determined by the
parameter \code{element_expr}.
}
\description{
Create lists of elements using an expressive syntax. Internally nested
for-loops are created and compiled that generate the list.
}
\details{
For parallel iterations all elements in the \code{list} need to be of
equal length. This is not checked at runtime at the moment.
}
\examples{
gen_list(c(x, y), x = 1:10, y = 1:10, x + y == 10, x < y)
z <- 10
gen_list(c(x, y), x = 1:10, y = 1:10, x + y == !!z, x < y)

# it is also possible to iterate in parallel by passing a list of
# sequences
gen_list(c(x, y), list(x = 1:10, y = 1:10), (x + y) \%in\% c(4, 6))

}
