% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_nodes_to_lints.R
\name{xml_nodes_to_lints}
\alias{xml_nodes_to_lints}
\title{Convert an XML node or nodeset into a Lint}
\usage{
xml_nodes_to_lints(
  xml,
  source_expression,
  lint_message,
  type = c("style", "warning", "error"),
  column_number_xpath = range_start_xpath,
  range_start_xpath = "number(./@col1)",
  range_end_xpath = "number(./@col2)"
)
}
\arguments{
\item{xml}{An \code{xml_node} object (to generate one \code{Lint}) or an
\code{xml_nodeset} object (to generate several \code{Lint}s), e.g. as returned by
\code{\link[xml2:xml_find_all]{xml2::xml_find_all()}} or \code{\link[xml2:xml_find_all]{xml2::xml_find_first()}} or a
list of \code{xml_node} objects.}

\item{source_expression}{A source expression object, e.g. as
returned typically by \code{\link[=lint]{lint()}}, or more generally
by \code{\link[=get_source_expressions]{get_source_expressions()}}.}

\item{lint_message}{The message to be included as the \code{message}
to the \code{Lint} object. If \code{lint_message} is a character vector the same length as \code{xml},
the \code{i}-th lint will be given the \code{i}-th message.}

\item{type}{type of lint.}

\item{column_number_xpath}{XPath expression to return the column number location of the lint.
Defaults to the start of the range matched by \code{range_start_xpath}. See details for more information.}

\item{range_start_xpath}{XPath expression to return the range start location of the lint.
Defaults to the start of the expression matched by \code{xml}. See details for more information.}

\item{range_end_xpath}{XPath expression to return the range end location of the lint.
Defaults to the end of the expression matched by \code{xml}. See details for more information.}
}
\value{
For \code{xml_node}s, a \code{lint}. For \code{xml_nodeset}s, \code{lints} (a list of \code{lint}s).
}
\description{
Convenience function for converting nodes matched by XPath-based
linter logic into a \code{\link[=Lint]{Lint()}} object to return.
}
\details{
The location XPaths, \code{column_number_xpath}, \code{range_start_xpath} and \code{range_end_xpath} are evaluated using
\code{\link[xml2:xml_find_all]{xml2::xml_find_num()}} and will usually be of the form \code{"number(./relative/xpath)"}.
Note that the location line number cannot be changed and lints spanning multiple lines will ignore \code{range_end_xpath}.
\code{column_number_xpath} and \code{range_start_xpath} are assumed to always refer to locations on the starting line of the
\code{xml} node.
}
