% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initControls.R
\name{setenv_GRASS4W}
\alias{setenv_GRASS4W}
\title{Create valid 'GRASS GIS 7.xx' rsession environment settings}
\usage{
setenv_GRASS4W(root_GRASS = "C:\\\\OSGEO4~1", grass_version = "grass-7.0.5",
  installation_type = "osgeo4W", jpgmem = 1e+06)
}
\arguments{
\item{root_GRASS}{grass root directory i.e. "C:\\OSGEO4~1",}

\item{grass_version}{grass version name i.e. "grass-7.0.5"}

\item{installation_type}{two options "osgeo4w" as installed by the 'OSGeo4W'-installer and "NSIS" that is typical for a stand_alone installtion of 'GRASS GIS'.}

\item{jpgmem}{jpeg2000 memory allocation size. Default is 1000000}
}
\value{
Set all necessary environment variables and additionally returns the GISBASE directory as string.
}
\description{
Initializes and set up  access to 'GRASS GIS 7.xx' via the \link{rgrass7} wrapper or command line packages
}
\examples{
\dontrun{
# get all valid 'GRASS GIS' installation folders and params
grassParam<- setenv_GRASS4W()
}
}
\author{
Chris Reudenbach
}
