% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.MetaTOpathway.r
\name{lilikoi.MetaTOpathway}
\alias{lilikoi.MetaTOpathway}
\title{A MetaTOpathway Function}
\usage{
lilikoi.MetaTOpathway(
  q.type,
  hmdb = TRUE,
  pubchem = TRUE,
  chebi = FALSE,
  kegg = TRUE,
  metlin = FALSE
)
}
\arguments{
\item{q.type}{The type of the metabolites id such as 'name', 'kegg', 'hmdb','pubchem'}

\item{hmdb}{if TRUE, match metabolites id to the HMDB database.}

\item{pubchem}{if TRUE, match metabolites id to the PubChem database.}

\item{chebi}{if TRUE, match metabolites id to the ChEBI database.}

\item{kegg}{if TRUE, match metabolites id to the KEGG database.}

\item{metlin}{if TRUE, match metabolites id to the METLIN database.}
}
\value{
A table showing the convertion results from metabolites ids to ids in different metabolomics databases and pathway ids and names.
}
\description{
This function allows you to convert your metabolites id such as names, kegg ids, pubchem ids.
into pathways. Metabolites which have not pathways will be excluded from any downstream analysis
make sure that you have three database files which are used for exact and fuzzy matching:
cmpd_db.rda, syn_nms_db.rda and Sijia_pathway.rda
This function was modified version of the name.match function in the below link:
https://github.com/cangfengzhe/Metabo/blob/master/MetaboAnalyst/website/name_match.R
}
\examples{
\donttest{
dt <- lilikoi.Loaddata(file=system.file("extdata",
  "plasma_breast_cancer.csv", package = "lilikoi"))
Metadata <- dt$Metadata
dataSet <- dt$dataSet
# Metabolite_pathway_table=lilikoi.MetaTOpathway('name')
}

}
\keyword{Match}
