% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxel_metrics.R
\name{voxel_metrics}
\alias{voxel_metrics}
\title{Voxelize the space and compute metrics for each voxel}
\usage{
voxel_metrics(las, func, res = 1, ..., all_voxels = FALSE)
}
\arguments{
\item{las}{An object of class \code{LAS}.}

\item{func}{formula. An expression to be applied to each voxel (see also \link{grid_metrics}).}

\item{res}{numeric. The resolution of the voxels. \code{res = 1} for a 1x1x1 cubic voxels. Optionally
\code{res = c(1,2)} for non-cubic voxels (1x1x2 cuboid voxel).}

\item{...}{Unused}

\item{all_voxels}{boolean. By default the function returns only voxels that
contain 1 or more points. Empty voxels do not exist as the metrics are undefined.
If \code{all_voxels = TRUE} all the voxels are returned and metrics are NA for
voxels with 0 points.}
}
\value{
It returns a \code{data.table} containing the metrics for each voxel. The table
has the class \code{lasmetrics3d} enabling easier plotting. It also has an
attribute \code{res} that stores the resolution.
}
\description{
This is a 3D version of \link{grid_metrics}. It creates a 3D matrix of voxels with a given resolution.
It creates a voxel from the cloud of points if there is at least one point in the voxel. For each voxel
the function allows computation of one or several derived metrics in the same way as the \link{grid_metrics}
functions. The function will dispatch the LiDAR data for each voxel in the user's function (see \link{grid_metrics}).
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

# Cloud of points is voxelized with a 8-meter resolution and in each voxel
# the number of points is computed.
vm <- voxel_metrics(las, ~length(Z), 8)

# Cloud of points is voxelized with a 8-meter resolution and in each voxel
# the mean intensity of points is computed.
vm <- voxel_metrics(las, ~mean(Intensity), 8)
#plot(vm, color = "V1", colorPalette = heat.colors(50), trim = 60)

# Define your own metric function
myMetrics = function(i)
{
  ret = list(
     npoints = length(i),
     imean   = mean(i)
   )

   return(ret)
}

voxels <- voxel_metrics(las, ~myMetrics(Intensity), 8)

#plot(voxels, color = "imean", colorPalette = heat.colors(50), trim = 60)
#etc.

attr(voxels, "res")
}
\seealso{
Other metrics: 
\code{\link{cloud_metrics}()},
\code{\link{grid_metrics}()},
\code{\link{plot_metrics}()},
\code{\link{point_metrics}()},
\code{\link{tree_metrics}()}
}
\concept{metrics}
