% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-its.R
\name{silva2016}
\alias{silva2016}
\title{Individual Tree Segmentation Algorithm}
\usage{
silva2016(chm, treetops, max_cr_factor = 0.6, exclusion = 0.3, ID = "treeID")
}
\arguments{
\item{chm}{RasterLayer. Image of the canopy. Can be computed with \link{grid_canopy} or read from
an external file.}

\item{treetops}{\code{SpatialPointsDataFrame}. Can be computed with
\link{find_trees} or read from an external shapefile.}

\item{max_cr_factor}{numeric. Maximum value of a crown diameter given as a proportion of the
tree height. Default is 0.6, meaning 60\% of the tree height.}

\item{exclusion}{numeric. For each tree, pixels with an elevation lower than \code{exclusion}
multiplied by the tree height will be removed. Thus, this number belongs between 0 and 1.}

\item{ID}{character. If the \code{SpatialPointsDataFrame} contains an attribute with the ID for
each tree, the name of this column. This way, original IDs will be preserved. If there is no such
data trees will be numbered sequentially.}
}
\description{
This functions is made to be used in \link{segment_trees}. It implements an algorithm for tree
segmentation based on the Silva et al. (2016) article (see reference). This is a simple method
based on seed + voronoi tesselation (equivalent to nearest neighbour). This algorithm is implemented
in the package \code{rLiDAR}. This version is \emph{not} the version from \code{rLiDAR}. It is
code written from the original article by the lidR authors and is considerably (between 250
and 1000 times) faster.
}
\details{
Because this algorithm works on a CHM only there is no actual need for a point cloud. Sometimes the
user does not even have the point cloud that generated the CHM. \code{lidR} is a point cloud-oriented
library, which is why this algorithm must be used in \link{segment_trees} to merge the result into the point
cloud. However, the user can use this as a stand-alone function like this:
\preformatted{
 chm = raster("file/to/a/chm/")
 ttops = find_trees(chm, lmf(3))
 crowns = silva2016(chm, ttops)()
}
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")
col <- pastel.colors(200)

chm <- grid_canopy(las, res = 0.5, p2r(0.3))
ker <- matrix(1,3,3)
chm <- raster::focal(chm, w = ker, fun = mean, na.rm = TRUE)

ttops <- find_trees(chm, lmf(4, 2))
las   <- segment_trees(las, silva2016(chm, ttops))
plot(las, color = "treeID", colorPalette = col)
}
\references{
Silva, C. A., Hudak, A. T., Vierling, L. A., Loudermilk, E. L., O’Brien, J. J., Hiers,
J. K., Khosravipour, A. (2016). Imputation of Individual Longleaf Pine (Pinus palustris Mill.)
Tree Attributes from Field and LiDAR Data. Canadian Journal of Remote Sensing, 42(5), 554–573.
https://doi.org/10.1080/07038992.2016.1196582.
}
\seealso{
Other individual tree segmentation algorithms: 
\code{\link{dalponte2016}()},
\code{\link{li2012}()},
\code{\link{watershed}()}

Other raster based tree segmentation algorithms: 
\code{\link{dalponte2016}()},
\code{\link{watershed}()}
}
\concept{individual tree segmentation algorithms}
\concept{raster based tree segmentation algorithms}
