% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasrescale.R
\name{lasrescale}
\alias{lasrescale}
\alias{lasreoffset}
\title{Rescale and reoffset a LAS object}
\usage{
lasrescale(las, xscale, yscale, zscale)

lasreoffset(las, xoffset, yoffset, zoffset)
}
\arguments{
\item{las}{An object of class LAS}

\item{xscale, yscale, zscale}{scalar. Can be missing if not relevant.}

\item{xoffset, yoffset, zoffset}{scalar. Can be missing if not relevant.}
}
\description{
Modify the scale factor and the offset of a LAS object. This function modify the header and
recompute the coordinates. Coordinates might be moved by few tenth of millimeters or few
millimeters depending of the accuracy imposed by the user.
}
\examples{
LASfile <- system.file("extdata", "example.laz", package = "rlas")
las <- readLAS(LASfile)

las <- lasrescale(las, xscale = 0.01, yscale = 0.01)
las <- lasreoffset(las, xoffset = 300000, yoffset = 5248000)
}
