% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasfiltersurfacepoints.r
\name{lasfiltersurfacepoints}
\alias{lasfiltersurfacepoints}
\title{Filter the surface points}
\usage{
lasfiltersurfacepoints(las, res)
}
\arguments{
\item{las}{A LAS object}

\item{res}{numeric. The resolution of the grid used to filter the point cloud}
}
\value{
A LAS object
}
\description{
This routine creates a grid with a given resolution and filters the point cloud by selecting the
highest point within each cell.
}
\details{
This function is different from \link{grid_canopy} even if the overall concept is exactly the same.
\code{grid_canopy} attributes to each cell the elevation of the highest points and the point cloud is
rasterized. Here, there is no rasterization, the function takes a point cloud as input and a point
cloud as output. Coordinates and attributes are preserved.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)
subset = lasfiltersurfacepoints(las, 2)
plot(subset)
}
\seealso{
Other lasfilters: \code{\link{lasfilters}},
  \code{\link{lasfilter}}
}
