% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{catalog_reshape}
\alias{catalog_reshape}
\title{Reshape (retile) a catalog}
\usage{
catalog_reshape(ctg, size, path, prefix, ext = c("las", "laz"))
}
\arguments{
\item{ctg}{A \link[lidR:catalog]{LAScatalog} object}

\item{size}{scalar. The size of the new tiles.}

\item{path}{string. The folder where the new files should be saved.}

\item{prefix}{character. The initial part of the name of the written files.}

\item{ext}{character. The format of the written files. Can be ".las" or ".laz".}
}
\value{
A new catalog object
}
\description{
This function is supersed by \link{catalog_retile} that can do the same and much more.
}
\examples{
\dontrun{
ctg = catalog("path/to/catalog")

# Create a new set of .las files 500 by 500 wide in the folder
# path/to/new/catalog/ and iteratively named Forest_1.las, Forest_2.las
# Forest_3.las, and so on.
newctg = catalog_reshape(ctg, 500, "path/to/new/catalog", "Forest_")
}
}
\seealso{
\link{catalog}
}
