/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRIVATE_ESTIMATION_H
#define _SO_PRIVATE_ESTIMATION_H

#include <libxml/xmlwriter.h>

#include <so/private/PopulationEstimates.h>
#include <so/private/PrecisionPopulationEstimates.h>
#include <so/private/IndividualEstimates.h>
#include <so/private/PrecisionIndividualEstimates.h>
#include <so/private/Residuals.h>
#include <so/private/Table.h>
#include <so/private/OFMeasures.h>
#include <so/private/TargetToolMessages.h>

struct so_Estimation {
	so_PopulationEstimates *PopulationEstimates;
	so_PrecisionPopulationEstimates *PrecisionPopulationEstimates;
	so_IndividualEstimates *IndividualEstimates;
	so_PrecisionIndividualEstimates *PrecisionIndividualEstimates;
	so_Residuals *Residuals;
	so_Table *Predictions;
	so_OFMeasures *OFMeasures;
	so_TargetToolMessages *TargetToolMessages;
	int in_PopulationEstimates;
	int in_PrecisionPopulationEstimates;
	int in_IndividualEstimates;
	int in_PrecisionIndividualEstimates;
	int in_Residuals;
	int in_Predictions;
	int in_OFMeasures;
	int in_TargetToolMessages;
	int reference_count;
};

int so_Estimation_start_element(so_Estimation *self, const char *localname, int nb_attributes, const char **attributes);
void so_Estimation_end_element(so_Estimation *self, const char *localname);
int so_Estimation_characters(so_Estimation *self, const char *ch, int len);
int so_Estimation_xml(so_Estimation *self, xmlTextWriterPtr writer);

#endif
