/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_ESTIMATION_H
#define _SO_ESTIMATION_H

#include <so/PopulationEstimates.h>
#include <so/PrecisionPopulationEstimates.h>
#include <so/IndividualEstimates.h>
#include <so/PrecisionIndividualEstimates.h>
#include <so/Residuals.h>
#include <so/Table.h>
#include <so/OFMeasures.h>
#include <so/TargetToolMessages.h>

/** \struct so_Estimation
	 \brief A structure representing an SO/SOBlock/Estimation element
*/
typedef struct so_Estimation so_Estimation;

/** \memberof so_Estimation
 * Create a new empty so_Estimation structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Estimation_copy, so_Estimation_free
 */
so_Estimation *so_Estimation_new();
/** \memberof so_Estimation
 * Create a copy of a so_Estimation structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Estimation_new
 */
so_Estimation *so_Estimation_copy(so_Estimation *self);
/** \memberof so_Estimation
 * Free all memory associated with a so_Estimation structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_Estimation_new
 */
void so_Estimation_free(so_Estimation *self);
void so_Estimation_ref(so_Estimation *self);
void so_Estimation_unref(so_Estimation *self);
/** \memberof so_Estimation
 * Get the PopulationEstimates element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the PopulationEstimates element
 * \sa so_Estimation_set_PopulationEstimates
 */
so_PopulationEstimates *so_Estimation_get_PopulationEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Get the PrecisionPopulationEstimates element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the PrecisionPopulationEstimates element
 * \sa so_Estimation_set_PrecisionPopulationEstimates
 */
so_PrecisionPopulationEstimates *so_Estimation_get_PrecisionPopulationEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Get the IndividualEstimates element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the IndividualEstimates element
 * \sa so_Estimation_set_IndividualEstimates
 */
so_IndividualEstimates *so_Estimation_get_IndividualEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Get the PrecisionIndividualEstimates element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the PrecisionIndividualEstimates element
 * \sa so_Estimation_set_PrecisionIndividualEstimates
 */
so_PrecisionIndividualEstimates *so_Estimation_get_PrecisionIndividualEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Get the Residuals element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the Residuals element
 * \sa so_Estimation_set_Residuals
 */
so_Residuals *so_Estimation_get_Residuals(so_Estimation *self);
/** \memberof so_Estimation
 * Get the Predictions element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the Predictions element
 * \sa so_Estimation_set_Predictions
 */
so_Table *so_Estimation_get_Predictions(so_Estimation *self);
/** \memberof so_Estimation
 * Get the OFMeasures element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the OFMeasures element
 * \sa so_Estimation_set_OFMeasures
 */
so_OFMeasures *so_Estimation_get_OFMeasures(so_Estimation *self);
/** \memberof so_Estimation
 * Get the TargetToolMessages element
 * \param self - pointer to a so_Estimation
 * \return A pointer to the structure representing the TargetToolMessages element
 * \sa so_Estimation_set_TargetToolMessages
 */
so_TargetToolMessages *so_Estimation_get_TargetToolMessages(so_Estimation *self);
/** \memberof so_Estimation
 * Set the PopulationEstimates element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_PopulationEstimates to set.
 * \sa so_Estimation_get_PopulationEstimates
 */
void so_Estimation_set_PopulationEstimates(so_Estimation *self, so_PopulationEstimates *value);
/** \memberof so_Estimation
 * Set the PrecisionPopulationEstimates element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_PrecisionPopulationEstimates to set.
 * \sa so_Estimation_get_PrecisionPopulationEstimates
 */
void so_Estimation_set_PrecisionPopulationEstimates(so_Estimation *self, so_PrecisionPopulationEstimates *value);
/** \memberof so_Estimation
 * Set the IndividualEstimates element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_IndividualEstimates to set.
 * \sa so_Estimation_get_IndividualEstimates
 */
void so_Estimation_set_IndividualEstimates(so_Estimation *self, so_IndividualEstimates *value);
/** \memberof so_Estimation
 * Set the PrecisionIndividualEstimates element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_PrecisionIndividualEstimates to set.
 * \sa so_Estimation_get_PrecisionIndividualEstimates
 */
void so_Estimation_set_PrecisionIndividualEstimates(so_Estimation *self, so_PrecisionIndividualEstimates *value);
/** \memberof so_Estimation
 * Set the Residuals element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_Residuals to set.
 * \sa so_Estimation_get_Residuals
 */
void so_Estimation_set_Residuals(so_Estimation *self, so_Residuals *value);
/** \memberof so_Estimation
 * Set the Predictions element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Estimation_get_Predictions
 */
void so_Estimation_set_Predictions(so_Estimation *self, so_Table *value);
/** \memberof so_Estimation
 * Set the OFMeasures element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_OFMeasures to set.
 * \sa so_Estimation_get_OFMeasures
 */
void so_Estimation_set_OFMeasures(so_Estimation *self, so_OFMeasures *value);
/** \memberof so_Estimation
 * Set the TargetToolMessages element
 * \param self - pointer to a so_Estimation
 * \param value - A pointer to a \a so_TargetToolMessages to set.
 * \sa so_Estimation_get_TargetToolMessages
 */
void so_Estimation_set_TargetToolMessages(so_Estimation *self, so_TargetToolMessages *value);
/** \memberof so_Estimation
 * Create a new PopulationEstimates element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_PopulationEstimates *so_Estimation_create_PopulationEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new PrecisionPopulationEstimates element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_PrecisionPopulationEstimates *so_Estimation_create_PrecisionPopulationEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new IndividualEstimates element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_IndividualEstimates *so_Estimation_create_IndividualEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new PrecisionIndividualEstimates element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_PrecisionIndividualEstimates *so_Estimation_create_PrecisionIndividualEstimates(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new Residuals element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Residuals *so_Estimation_create_Residuals(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new Predictions element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Estimation_create_Predictions(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new OFMeasures element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_OFMeasures *so_Estimation_create_OFMeasures(so_Estimation *self);
/** \memberof so_Estimation
 * Create a new TargetToolMessages element and insert it into the so_Estimation
 * \param self - pointer to a so_Estimation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_TargetToolMessages *so_Estimation_create_TargetToolMessages(so_Estimation *self);

#endif
