/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Residuals.h>
#include <so/private/Residuals.h>

so_Residuals *so_Residuals_new()
{
	so_Residuals *object = calloc(sizeof(so_Residuals), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Residuals *so_Residuals_copy(so_Residuals *self)
{
	so_Residuals *dest = so_Residuals_new();
	if (dest) {
		if (self->ResidualTable) {
			dest->ResidualTable = so_Table_copy(self->ResidualTable);
			if (!dest->ResidualTable) {
				so_Residuals_free(dest);
				return NULL;
			}
		}
		if (self->EpsShrinkage) {
			dest->EpsShrinkage = so_Table_copy(self->EpsShrinkage);
			if (!dest->EpsShrinkage) {
				so_Residuals_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_Residuals_free(so_Residuals *self)
{
	if (self) {
		so_Table_unref(self->ResidualTable);
		so_Table_unref(self->EpsShrinkage);
		free(self);
	}
}

void so_Residuals_ref(so_Residuals *self)
{
	self->reference_count++;
}

void so_Residuals_unref(so_Residuals *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Residuals_free(self);
		}
	}
}

so_Table *so_Residuals_get_ResidualTable(so_Residuals *self)
{
	return self->ResidualTable;
}

so_Table *so_Residuals_get_EpsShrinkage(so_Residuals *self)
{
	return self->EpsShrinkage;
}

void so_Residuals_set_ResidualTable(so_Residuals *self, so_Table *value)
{
	so_Table_unref(self->ResidualTable);
	self->ResidualTable = value;
}

void so_Residuals_set_EpsShrinkage(so_Residuals *self, so_Table *value)
{
	so_Table_unref(self->EpsShrinkage);
	self->EpsShrinkage = value;
}

so_Table *so_Residuals_create_ResidualTable(so_Residuals *self)
{
	so_Table *obj = so_Table_new("ResidualTable");
	if (obj) {
		self->ResidualTable = obj;
	}
	return obj;
}

so_Table *so_Residuals_create_EpsShrinkage(so_Residuals *self)
{
	so_Table *obj = so_Table_new("EpsShrinkage");
	if (obj) {
		self->EpsShrinkage = obj;
	}
	return obj;
}

int so_Residuals_xml(so_Residuals *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->ResidualTable || self->EpsShrinkage) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Residuals");
		if (rc < 0) return 1;
		if (self->ResidualTable) {
			rc = so_Table_xml(self->ResidualTable, writer, "ResidualTable");
			if (rc != 0) return rc;
		}
		if (self->EpsShrinkage) {
			rc = so_Table_xml(self->EpsShrinkage, writer, "EpsShrinkage");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Residuals_start_element(so_Residuals *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_ResidualTable) {
		int fail = so_Table_start_element(self->ResidualTable, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_EpsShrinkage) {
		int fail = so_Table_start_element(self->EpsShrinkage, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "ResidualTable") == 0) {
		so_Table *ResidualTable = so_Residuals_create_ResidualTable(self);
		if (!ResidualTable) {
			return 1;
		}
		self->in_ResidualTable = 1;
	} else if (strcmp(localname, "EpsShrinkage") == 0) {
		so_Table *EpsShrinkage = so_Residuals_create_EpsShrinkage(self);
		if (!EpsShrinkage) {
			return 1;
		}
		self->in_EpsShrinkage = 1;
	}
	return 0;
}

void so_Residuals_end_element(so_Residuals *self, const char *localname)
{
	if (strcmp(localname, "ResidualTable") == 0 && self->in_ResidualTable) {
		self->in_ResidualTable = 0;
	} else if (strcmp(localname, "EpsShrinkage") == 0 && self->in_EpsShrinkage) {
		self->in_EpsShrinkage = 0;
	} else if (self->in_ResidualTable) {
		so_Table_end_element(self->ResidualTable, localname);
	} else if (self->in_EpsShrinkage) {
		so_Table_end_element(self->EpsShrinkage, localname);
	}
}

int so_Residuals_characters(so_Residuals *self, const char *ch, int len)
{
	if (self->in_ResidualTable) {
		int fail = so_Table_characters(self->ResidualTable, ch, len);
		if (fail) return 1;
	} else if (self->in_EpsShrinkage) {
		int fail = so_Table_characters(self->EpsShrinkage, ch, len);
		if (fail) return 1;
	}
	return 0;
}
