/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_OFMeasures_new()
{
	so_OFMeasures *obj = so_OFMeasures_new();
	if (!obj) {
		error("Failed to create so_OFMeasures object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_OFMeasures_copy(SEXP self)
{
	so_OFMeasures *obj = so_OFMeasures_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_OFMeasures object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_OFMeasures_free(SEXP self)
{
	so_OFMeasures_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OFMeasures_ref(SEXP self)
{
	so_OFMeasures_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OFMeasures_unref(SEXP self)
{
	so_OFMeasures_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OFMeasures_get_Likelihood(SEXP self)
{
	double *child = so_OFMeasures_get_Likelihood(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_NUMERIC(1));
	REAL(result)[0] = *child;
	UNPROTECT(1);
	return result;
}

SEXP r_so_OFMeasures_set_Likelihood(SEXP self, SEXP child)
{
	so_OFMeasures_set_Likelihood(R_ExternalPtrAddr(self), REAL(child));
	return R_NilValue;
}


SEXP r_so_OFMeasures_get_LogLikelihood(SEXP self)
{
	double *child = so_OFMeasures_get_LogLikelihood(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_NUMERIC(1));
	REAL(result)[0] = *child;
	UNPROTECT(1);
	return result;
}

SEXP r_so_OFMeasures_set_LogLikelihood(SEXP self, SEXP child)
{
	so_OFMeasures_set_LogLikelihood(R_ExternalPtrAddr(self), REAL(child));
	return R_NilValue;
}


SEXP r_so_OFMeasures_get_Deviance(SEXP self)
{
	double *child = so_OFMeasures_get_Deviance(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_NUMERIC(1));
	REAL(result)[0] = *child;
	UNPROTECT(1);
	return result;
}

SEXP r_so_OFMeasures_set_Deviance(SEXP self, SEXP child)
{
	so_OFMeasures_set_Deviance(R_ExternalPtrAddr(self), REAL(child));
	return R_NilValue;
}


SEXP r_so_OFMeasures_get_ToolObjFunction(SEXP self)
{
	double *child = so_OFMeasures_get_ToolObjFunction(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_NUMERIC(1));
	REAL(result)[0] = *child;
	UNPROTECT(1);
	return result;
}

SEXP r_so_OFMeasures_set_ToolObjFunction(SEXP self, SEXP child)
{
	so_OFMeasures_set_ToolObjFunction(R_ExternalPtrAddr(self), REAL(child));
	return R_NilValue;
}


SEXP r_so_OFMeasures_get_IndividualContribtoLL(SEXP self)
{
	so_Table *child = so_OFMeasures_get_IndividualContribtoLL(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}

SEXP r_so_OFMeasures_set_IndividualContribtoLL(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_OFMeasures_set_IndividualContribtoLL(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}

SEXP r_so_OFMeasures_create_IndividualContribtoLL(SEXP self)
{
	so_Table *child = so_OFMeasures_create_IndividualContribtoLL(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_OFMeasures_get_InformationCriteria(SEXP self)
{
	so_InformationCriteria *child = so_OFMeasures_get_InformationCriteria(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_OFMeasures_set_InformationCriteria(SEXP self, SEXP child)
{
	so_OFMeasures_set_InformationCriteria(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_OFMeasures_create_InformationCriteria(SEXP self)
{
	so_InformationCriteria *child = so_OFMeasures_create_InformationCriteria(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

