% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_funs.R
\name{make_dirs}
\alias{make_dirs}
\title{Build a path, creating subfolders if needed}
\usage{
make_dirs(...)
}
\arguments{
\item{...}{(Character) Arguments to send to \code{file.path()}. You can provide a complete
path as a single string, or incrementally build a path with many strings.}
}
\value{
(Character) A file path. Automatically adds trailing slashes if required.
}
\description{
Whereas \code{base::file.path()} only concatenates strings to build a path, \code{make_dirs()}
\emph{also} makes sure those folders exist.
}
\section{Authors}{

\itemize{
\item Desi Quintans (\url{http://www.desiquintans.com})
}
}

\section{Source}{

\itemize{
\item Desiderata package (\url{https://github.com/DesiQuintans/desiderata})
}
}

\examples{
\dontrun{
make_dirs(tempdir(), "newfolder")

#> [1] "C:/Users/.../Temp/RtmpSwZA8X/newfolder"
}

}
