% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call-numbers-and-subject.R
\name{get_dewey_decimal_subject_division}
\alias{get_dewey_decimal_subject_division}
\title{Conversion from Dewey Decimal call numbers to second-level subject description}
\usage{
get_dewey_decimal_subject_division(x)
}
\arguments{
\item{x}{A Dewey Decimal call number}
}
\value{
Returns the most general subject classification using the
        first two digits from the DCC. Returns NA if the DCC looks
        invalid
}
\description{
Takes a string representation of a Dewey Decimal
call number (DCC) and returns it's subject description.
This uses the first two digits of the DCC number
and returns the second most general subject classification.
}
\examples{

get_dewey_decimal_subject_division("709.05")     # Arts

get_dewey_decimal_subject_division("823.912")
# "English and Old English literatures"

# vectorized
get_dewey_decimal_subject_division(c("709.05", "invalid", NA, "823.912"))
# c("Arts", NA, NA, "English and Old English literatures")

}
