% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-attributes.R
\name{cp_lb_attributes}
\alias{cp_lb_attributes}
\title{Copy special libbib attributes from one object to another}
\usage{
cp_lb_attributes(a, b)
}
\arguments{
\item{a}{The first object (the one with the attributes to copy)}

\item{b}{The second object (the one to copy those attributes to)}
}
\value{
Nothing, since the object is modified by reference.
}
\description{
Takes two objects and copies all special libbib attributes
(attributes beginning with \code{lb.}) from the first object
to the second, by reference.
}
\examples{

tmp1 <- "a"
set_lb_date(tmp1, "2021-05-08")
set_lb_attribute(tmp1, "note", "just an example")

tmp2 <- "b"
cp_lb_attributes(tmp1, tmp2)
attributes(tmp2)$lb.date
# [1] "2021-05-08"
attributes(tmp2)$lb.note
# [1] "just an example"

}
