/**
 * @brief Stopping Power
 */

/*
 *    AT_DataStoppingPower.c
 *    ==============
 *
 *    Created on: 12.11.2010
 *    Creator: kongruencja
 *
 *    Copyright 2006, 2010 The libamtrack team
 *
 *    This file is part of the AmTrack program (libamtrack.sourceforge.net).
 *
 *    AmTrack is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    AmTrack is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with AmTrack (file: copying.txt).
 *    If not, see <http://www.gnu.org/licenses/>
 */

#include "AT_StoppingPowerDataICRU.h"

AT_stopping_power_ICRU_table_struct AT_stopping_power_ICRU_table[2] = {
		{   Water_Liquid,
			53,
			{	{0.025000, 0.030000, 0.040000, 0.050000, 0.060000, 0.070000, 0.080000, 0.090000, 0.100000, 0.150000, 0.200000, 0.250000, 0.300000, 0.400000, 0.500000, 0.600000, 0.700000, 0.800000, 0.900000, 1.000000, 1.500000, 2.000000, 2.500000, 3.000000, 4.000000, 5.000000, 6.000000, 7.000000, 8.000000, 9.000000, 10.000000, 15.000000, 20.000000, 25.000000, 30.000000, 40.000000, 50.000000, 60.000000, 70.000000, 80.000000, 90.000000, 100.000000, 150.000000, 200.000000, 250.000000, 300.000000, 400.000000, 500.000000, 600.000000, 700.000000, 800.000000, 900.000000, 1000.000000},
				{6.245e-01, 6.671e-01, 7.324e-01, 7.768e-01, 8.050e-01, 8.205e-01, 8.260e-01, 8.239e-01, 8.161e-01, 7.371e-01, 6.613e-01, 6.006e-01, 5.504e-01, 4.719e-01, 4.132e-01, 3.680e-01, 3.325e-01, 3.039e-01, 2.805e-01, 2.608e-01, 1.957e-01, 1.586e-01, 1.344e-01, 1.172e-01, 9.404e-02, 7.911e-02, 6.858e-02, 6.071e-02, 5.460e-02, 4.969e-02, 4.567e-02, 3.292e-02, 2.607e-02, 2.175e-02, 1.876e-02, 1.488e-02, 1.245e-02, 1.078e-02, 9.559e-03, 8.625e-03, 7.888e-03, 7.289e-03, 5.445e-03, 4.492e-03, 3.911e-03, 3.520e-03, 3.032e-03, 2.743e-03, 2.556e-03, 2.426e-03, 2.333e-03, 2.264e-03, 2.211e-03},
				{1.151e+00, 1.255e+00, 1.438e+00, 1.593e+00, 1.722e+00, 1.832e+00, 1.923e+00, 2.002e+00, 2.069e+00, 2.245e+00, 2.260e+00, 2.193e+00, 2.080e+00, 1.840e+00, 1.625e+00, 1.454e+00, 1.315e+00, 1.207e+00, 1.113e+00, 1.035e+00, 7.777e-01, 6.306e-01, 5.344e-01, 4.682e-01, 3.754e-01, 3.146e-01, 2.732e-01, 2.416e-01, 2.180e-01, 1.980e-01, 1.816e-01, 1.309e-01, 1.037e-01, 8.649e-02, 7.505e-02, 5.942e-02, 4.952e-02, 4.297e-02, 3.807e-02, 3.446e-02, 3.145e-02, 2.901e-02, 2.168e-02, 1.789e-02, 1.558e-02,   0,   0,   0,   0,   0,   0,   0,   0},
				{2.626e+00, 2.840e+00, 3.191e+00, 3.461e+00, 3.665e+00, 3.817e+00, 3.927e+00, 4.004e+00, 4.056e+00, 4.102e+00, 3.998e+00, 3.853e+00, 3.702e+00, 3.413e+00, 3.158e+00, 2.934e+00, 2.739e+00, 2.567e+00, 2.415e+00, 2.280e+00, 1.782e+00, 1.465e+00, 1.247e+00, 1.087e+00, 8.706e-01, 7.299e-01, 6.310e-01, 5.575e-01, 5.005e-01, 4.550e-01, 4.178e-01, 3.004e-01, 2.376e-01, 1.981e-01, 1.708e-01, 1.354e-01, 1.132e-01, 9.803e-02, 8.692e-02, 7.842e-02, 7.171e-02, 6.627e-02, 4.950e-02, 4.085e-02, 3.557e-02, 3.203e-02, 2.760e-02, 2.498e-02, 2.327e-02, 2.210e-02, 2.126e-02, 2.064e-02, 2.016e-02},
				{3.272e+00, 3.565e+00, 4.061e+00, 4.463e+00, 4.790e+00, 5.052e+00, 5.258e+00, 5.419e+00, 5.542e+00, 5.803e+00, 5.787e+00, 5.675e+00, 5.529e+00, 5.215e+00, 4.912e+00, 4.634e+00, 4.381e+00, 4.152e+00, 3.944e+00, 3.756e+00, 3.026e+00, 2.533e+00, 2.179e+00, 1.913e+00, 1.542e+00, 1.296e+00, 1.122e+00, 9.911e-01, 8.898e-01, 8.087e-01, 7.423e-01, 5.335e-01, 4.219e-01, 3.518e-01, 3.034e-01, 2.406e-01, 2.013e-01, 1.743e-01, 1.545e-01, 1.394e-01, 1.275e-01, 1.178e-01, 8.805e-02, 7.266e-02, 6.328e-02, 5.698e-02, 4.910e-02, 4.444e-02, 4.141e-02, 3.933e-02, 3.783e-02, 3.672e-02, 3.588e-02},
				{3.773e+00, 4.142e+00, 4.776e+00, 5.304e+00, 5.749e+00, 6.122e+00, 6.431e+00, 6.684e+00, 6.890e+00, 7.432e+00, 7.551e+00, 7.505e+00, 7.391e+00, 7.091e+00, 6.772e+00, 6.463e+00, 6.172e+00, 5.901e+00, 5.650e+00, 5.418e+00, 4.484e+00, 3.817e+00, 3.322e+00, 2.940e+00, 2.392e+00, 2.020e+00, 1.752e+00, 1.549e+00, 1.391e+00, 1.265e+00, 1.161e+00, 8.332e-01, 6.587e-01, 5.492e-01, 4.737e-01, 3.757e-01, 3.144e-01, 2.723e-01, 2.415e-01, 2.179e-01, 1.993e-01, 1.842e-01, 1.376e-01, 1.136e-01, 9.894e-02, 8.909e-02, 7.678e-02, 6.950e-02, 6.477e-02, 6.151e-02, 5.916e-02, 5.743e-02, 5.611e-02},
				{4.154e+00, 4.593e+00, 5.358e+00, 6.009e+00, 6.568e+00, 7.049e+00, 7.460e+00, 7.809e+00, 8.103e+00, 8.968e+00, 9.262e+00, 9.311e+00, 9.250e+00, 8.994e+00, 8.680e+00, 8.358e+00, 8.045e+00, 7.747e+00, 7.465e+00, 7.199e+00, 6.093e+00, 5.269e+00, 4.636e+00, 4.137e+00, 3.403e+00, 2.891e+00, 2.516e+00, 2.230e+00, 2.004e+00, 1.823e+00, 1.673e+00, 1.200e+00, 9.483e-01, 7.904e-01, 6.817e-01, 5.406e-01, 4.525e-01, 3.920e-01, 3.477e-01, 3.138e-01, 2.870e-01, 2.653e-01, 1.983e-01, 1.637e-01, 1.426e-01, 1.284e-01, 1.107e-01, 1.002e-01, 9.335e-02, 8.865e-02, 8.528e-02, 8.278e-02, 8.088e-02},
				{4.490e+00, 4.984e+00, 5.860e+00, 6.616e+00, 7.276e+00, 7.854e+00, 8.360e+00, 8.799e+00, 9.179e+00, 1.039e+01, 1.089e+01, 1.107e+01, 1.108e+01, 1.090e+01, 1.061e+01, 1.030e+01, 9.974e+00, 9.660e+00, 9.357e+00, 9.068e+00, 7.823e+00, 6.859e+00, 6.097e+00, 5.484e+00, 4.560e+00, 3.900e+00, 3.408e+00, 3.029e+00, 2.727e+00, 2.482e+00, 2.280e+00, 1.636e+00, 1.291e+00, 1.076e+00, 9.274e-01, 7.354e-01, 6.156e-01, 5.333e-01, 4.731e-01, 4.270e-01, 3.906e-01, 3.611e-01, 2.700e-01, 2.229e-01, 1.942e-01, 1.749e-01, 1.507e-01, 1.365e-01, 1.272e-01, 1.208e-01, 1.162e-01, 1.128e-01, 1.102e-01},
				{4.778e+00, 5.321e+00, 6.298e+00, 7.152e+00, 7.907e+00, 8.578e+00, 9.173e+00, 9.700e+00, 1.016e+01, 1.173e+01, 1.246e+01, 1.278e+01, 1.289e+01, 1.281e+01, 1.257e+01, 1.227e+01, 1.195e+01, 1.163e+01, 1.132e+01, 1.101e+01, 9.659e+00, 8.571e+00, 7.691e+00, 6.967e+00, 5.854e+00, 5.042e+00, 4.427e+00, 3.945e+00, 3.560e+00, 3.245e+00, 2.983e+00, 2.142e+00, 1.689e+00, 1.406e+00, 1.212e+00, 9.602e-01, 8.037e-01, 6.963e-01, 6.178e-01, 5.577e-01, 5.102e-01, 4.716e-01, 3.527e-01, 2.913e-01, 2.538e-01, 2.285e-01, 1.970e-01, 1.784e-01, 1.663e-01, 1.579e-01, 1.519e-01, 1.475e-01, 1.441e-01},
				{4.992e+00, 5.575e+00, 6.637e+00, 7.578e+00, 8.418e+00, 9.171e+00, 9.847e+00, 1.045e+01, 1.100e+01, 1.290e+01, 1.388e+01, 1.435e+01, 1.456e+01, 1.459e+01, 1.440e+01, 1.413e+01, 1.383e+01, 1.351e+01, 1.319e+01, 1.287e+01, 1.144e+01, 1.026e+01, 9.279e+00, 8.463e+00, 7.187e+00, 6.237e+00, 5.506e+00, 4.928e+00, 4.461e+00, 4.076e+00, 3.753e+00, 2.707e+00, 2.137e+00, 1.779e+00, 1.533e+00, 1.215e+00, 1.017e+00, 8.809e-01, 7.816e-01, 7.056e-01, 6.456e-01, 5.969e-01, 4.466e-01, 3.688e-01, 3.213e-01, 2.894e-01, 2.496e-01, 2.259e-01, 2.106e-01, 2.000e-01, 1.924e-01, 1.868e-01, 1.825e-01},
				{5.182e+00, 5.797e+00, 6.931e+00, 7.948e+00, 8.865e+00, 9.693e+00, 1.044e+01, 1.112e+01, 1.174e+01, 1.398e+01, 1.521e+01, 1.585e+01, 1.617e+01, 1.633e+01, 1.621e+01, 1.598e+01, 1.569e+01, 1.538e+01, 1.506e+01, 1.474e+01, 1.324e+01, 1.198e+01, 1.091e+01, 1.001e+01, 8.584e+00, 7.503e+00, 6.660e+00, 5.986e+00, 5.436e+00, 4.979e+00, 4.595e+00, 3.332e+00, 2.635e+00, 2.195e+00, 1.892e+00, 1.499e+00, 1.255e+00, 1.087e+00, 9.646e-01, 8.709e-01, 7.969e-01, 7.368e-01, 5.514e-01, 4.555e-01, 3.969e-01, 3.576e-01, 3.083e-01, 2.792e-01, 2.602e-01, 2.472e-01, 2.378e-01, 2.308e-01, 2.255e-01},
				{5.352e+00, 5.998e+00, 7.203e+00, 8.300e+00, 9.298e+00, 1.021e+01, 1.104e+01, 1.181e+01, 1.250e+01, 1.513e+01, 1.668e+01, 1.756e+01, 1.804e+01, 1.843e+01, 1.844e+01, 1.829e+01, 1.805e+01, 1.778e+01, 1.748e+01, 1.718e+01, 1.567e+01, 1.432e+01, 1.315e+01, 1.214e+01, 1.050e+01, 9.226e+00, 8.218e+00, 7.401e+00, 6.728e+00, 6.166e+00, 5.690e+00, 4.112e+00, 3.237e+00, 2.686e+00, 2.307e+00, 1.821e+00, 1.521e+00, 1.317e+00, 1.168e+00, 1.054e+00, 9.644e-01, 8.917e-01, 6.674e-01, 5.514e-01, 4.806e-01, 4.329e-01, 3.734e-01, 3.381e-01, 3.152e-01, 2.993e-01, 2.880e-01, 2.796e-01, 2.732e-01},
				{5.542e+00, 6.193e+00, 7.420e+00, 8.551e+00, 9.590e+00, 1.054e+01, 1.142e+01, 1.223e+01, 1.298e+01, 1.585e+01, 1.762e+01, 1.866e+01, 1.926e+01, 1.976e+01, 1.983e+01, 1.970e+01, 1.947e+01, 1.920e+01, 1.889e+01, 1.858e+01, 1.702e+01, 1.562e+01, 1.441e+01, 1.336e+01, 1.164e+01, 1.030e+01, 9.233e+00, 8.362e+00, 7.640e+00, 7.033e+00, 6.516e+00, 4.777e+00, 3.792e+00, 3.162e+00, 2.725e+00, 2.159e+00, 1.806e+00, 1.565e+00, 1.388e+00, 1.254e+00, 1.147e+00, 1.061e+00, 7.944e-01, 6.565e-01, 5.722e-01, 5.156e-01, 4.447e-01, 4.027e-01, 3.754e-01, 3.566e-01, 3.430e-01, 3.330e-01, 3.254e-01},
				{5.724e+00, 6.390e+00, 7.649e+00, 8.820e+00, 9.905e+00, 1.091e+01, 1.184e+01, 1.271e+01, 1.351e+01, 1.666e+01, 1.869e+01, 1.993e+01, 2.068e+01, 2.138e+01, 2.156e+01, 2.150e+01, 2.132e+01, 2.107e+01, 2.079e+01, 2.048e+01, 1.891e+01, 1.747e+01, 1.619e+01, 1.508e+01, 1.324e+01, 1.178e+01, 1.061e+01, 9.641e+00, 8.835e+00, 8.153e+00, 7.569e+00, 5.583e+00, 4.444e+00, 3.710e+00, 3.199e+00, 2.534e+00, 2.120e+00, 1.836e+00, 1.629e+00, 1.471e+00, 1.346e+00, 1.245e+00, 9.325e-01, 7.707e-01, 6.719e-01, 6.054e-01, 5.223e-01, 4.730e-01, 4.410e-01, 4.189e-01, 4.030e-01, 3.912e-01, 3.823e-01},
				{5.905e+00, 6.583e+00, 7.868e+00, 9.073e+00, 1.020e+01, 1.125e+01, 1.223e+01, 1.314e+01, 1.399e+01, 1.740e+01, 1.966e+01, 2.110e+01, 2.201e+01, 2.291e+01, 2.321e+01, 2.322e+01, 2.309e+01, 2.287e+01, 2.261e+01, 2.232e+01, 2.076e+01, 1.928e+01, 1.795e+01, 1.678e+01, 1.483e+01, 1.326e+01, 1.199e+01, 1.094e+01, 1.006e+01, 9.304e+00, 8.656e+00, 6.430e+00, 5.135e+00, 4.294e+00, 3.705e+00, 2.938e+00, 2.458e+00, 2.129e+00, 1.889e+00, 1.706e+00, 1.561e+00, 1.444e+00, 1.082e+00, 8.942e-01, 7.796e-01, 7.026e-01, 6.061e-01, 5.490e-01, 5.119e-01, 4.862e-01, 4.678e-01, 4.542e-01, 4.438e-01},
				{6.120e+00, 6.810e+00, 8.118e+00, 9.352e+00, 1.051e+01, 1.161e+01, 1.263e+01, 1.358e+01, 1.448e+01, 1.813e+01, 2.063e+01, 2.228e+01, 2.334e+01, 2.447e+01, 2.491e+01, 2.502e+01, 2.495e+01, 2.478e+01, 2.455e+01, 2.428e+01, 2.276e+01, 2.126e+01, 1.989e+01, 1.867e+01, 1.659e+01, 1.492e+01, 1.354e+01, 1.239e+01, 1.142e+01, 1.059e+01, 9.867e+00, 7.367e+00, 5.896e+00, 4.935e+00, 4.259e+00, 3.376e+00, 2.824e+00, 2.445e+00, 2.169e+00, 1.959e+00, 1.792e+00, 1.657e+00, 1.242e+00, 1.027e+00, 8.954e-01, 8.070e-01, 6.963e-01, 6.308e-01, 5.881e-01, 5.587e-01, 5.375e-01, 5.219e-01, 5.100e-01},
				{6.294e+00, 7.000e+00, 8.338e+00, 9.604e+00, 1.080e+01, 1.194e+01, 1.300e+01, 1.400e+01, 1.494e+01, 1.882e+01, 2.155e+01, 2.341e+01, 2.465e+01, 2.601e+01, 2.660e+01, 2.681e+01, 2.681e+01, 2.669e+01, 2.650e+01, 2.626e+01, 2.479e+01, 2.328e+01, 2.188e+01, 2.061e+01, 1.843e+01, 1.664e+01, 1.516e+01, 1.392e+01, 1.286e+01, 1.195e+01, 1.115e+01, 8.371e+00, 6.715e+00, 5.624e+00, 4.856e+00, 3.847e+00, 3.217e+00, 2.785e+00, 2.470e+00, 2.229e+00, 2.040e+00, 1.886e+00, 1.413e+00, 1.169e+00, 1.019e+00, 9.187e-01, 7.929e-01, 7.183e-01, 6.697e-01, 6.362e-01, 6.122e-01, 5.944e-01, 5.808e-01},
				{6.522e+00, 7.237e+00, 8.590e+00, 9.875e+00, 1.110e+01, 1.226e+01, 1.336e+01, 1.439e+01, 1.537e+01, 1.945e+01, 2.240e+01, 2.445e+01, 2.586e+01, 2.746e+01, 2.819e+01, 2.850e+01, 2.857e+01, 2.850e+01, 2.834e+01, 2.813e+01, 2.672e+01, 2.521e+01, 2.378e+01, 2.247e+01, 2.020e+01, 1.832e+01, 1.675e+01, 1.542e+01, 1.428e+01, 1.330e+01, 1.244e+01, 9.392e+00, 7.557e+00, 6.340e+00, 5.479e+00, 4.344e+00, 3.633e+00, 3.145e+00, 2.789e+00, 2.517e+00, 2.303e+00, 2.130e+00, 1.596e+00, 1.320e+00, 1.151e+00, 1.038e+00, 8.957e-01, 8.115e-01, 7.567e-01, 7.189e-01, 6.917e-01, 6.717e-01, 6.563e-01},
				{6.642e+00, 7.369e+00, 8.739e+00, 1.004e+01, 1.128e+01, 1.247e+01, 1.359e+01, 1.466e+01, 1.566e+01, 1.993e+01, 2.308e+01, 2.532e+01, 2.689e+01, 2.872e+01, 2.960e+01, 3.001e+01, 3.015e+01, 3.013e+01, 3.000e+01, 2.982e+01, 2.846e+01, 2.694e+01, 2.549e+01, 2.415e+01, 2.181e+01, 1.986e+01, 1.822e+01, 1.682e+01, 1.561e+01, 1.457e+01, 1.365e+01, 1.039e+01, 8.394e+00, 7.063e+00, 6.114e+00, 4.859e+00, 4.067e+00, 3.522e+00, 3.125e+00, 2.821e+00, 2.581e+00, 2.387e+00, 1.789e+00, 1.480e+00, 1.291e+00, 1.164e+00, 1.005e+00, 9.105e-01, 8.491e-01, 8.067e-01, 7.763e-01, 7.537e-01, 7.365e-01}
			}
		},
		{ 	Aluminum_Oxide,
			53,
		    { 	{ 0.025, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6,0.7, 0.8, 0.9, 1, 1.5, 2, 2.5, 3, 4, 5, 6, 7, 8, 9, 10,
						15, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200,
						250, 300, 400, 500, 600, 700, 800, 900, 1000 }, { 340.8,
						364.9, 402.5, 429.2, 447.6, 459.6, 466.6, 469.8, 470,
						447.2, 412.7, 381.4, 354.5, 310.6, 276.5, 249.4, 227.9,
						210.2, 195.7, 183.2, 140.9, 116, 99.26, 87.2, 70.78,
						60.02, 52.36, 46.58, 42.06, 38.42, 35.41, 25.79, 20.55,
						17.22, 14.91, 11.88, 9.973, 8.658, 7.693, 6.953, 6.367,
						5.891, 4.419, 3.656, 3.189, 2.875, 2.482, 2.248, 2.094,
						1.987, 1.91, 1.852, 1.809 }, { 822.9, 889.3, 996.8,
						1080, 1144.2, 1196.8, 1238.8, 1274.4, 1304, 1378, 1381,
						1352, 1316.8, 1226.6, 1115, 1007.1, 918.72, 848.48,
						788.36, 737, 565.2, 464, 396.7, 349.74, 283.22, 239.2,
						208.92, 185.68, 168.12, 153.22, 140.9, 102.6, 81.77,
						68.52, 59.64, 47.452, 39.68, 34.512, 30.634, 27.782,
						25.394, 23.45, 17.59, 14.56, 12.7, 0, 0, 0, 0, 0, 0, 0,
						0 }, { 1360, 1470, 1650, 1810, 1930, 2030, 2120, 2180,
						2230, 2370, 2390, 2370, 2320, 2200, 2080, 1970, 1860,
						1760, 1670, 1590, 1280, 1070, 916.8, 805.7, 651.9,
						550.5, 478.5, 424.6, 382.6, 348.9, 321.2, 233.2, 185.5,
						155.3, 134.4, 107, 89.81, 77.96, 69.27, 62.6, 57.33,
						53.04, 39.8, 32.94, 28.74, 25.92, 22.39, 20.31, 18.95,
						18.02, 17.36, 16.86, 16.49 }, { 1730, 1880, 2140, 2360,
						2550, 2710, 2850, 2970, 3070, 3360, 3460, 3490, 3470,
						3370, 3240, 3110, 2970, 2850, 2730, 2620, 2170, 1840,
						1600, 1420, 1160, 979, 851.6, 755.6, 680.7, 620.5,
						571.2, 414.1, 329.5, 275.9, 238.7, 190.2, 159.7, 138.6,
						123.2, 111.3, 101.9, 94.33, 70.8, 58.6, 51.14, 46.12,
						39.85, 36.14, 33.73, 32.07, 30.89, 30.01, 29.34 }, {
						2040, 2230, 2560, 2850, 3090, 3310, 3500, 3670, 3820,
						4290, 4510, 4600, 4630, 4580, 4460, 4330, 4190, 4040,
						3910, 3770, 3210, 2780, 2440, 2180, 1800, 1530, 1330,
						1180, 1070, 971.4, 893.7, 647.1, 514.5, 430.8, 372.7,
						297, 249.4, 216.5, 192.4, 174, 159.3, 147.4, 110.7,
						91.62, 79.96, 72.12, 62.32, 56.51, 52.75, 50.16, 48.31,
						46.94, 45.9 }, { 2300, 2520, 2920, 3270, 3570, 3840,
						4090, 4310, 4500, 5180, 5530, 5700, 5790, 5800, 5720,
						5600, 5460, 5310, 5160, 5020, 4360, 3840, 3420, 3070,
						2560, 2190, 1920, 1710, 1540, 1400, 1290, 933.1, 741,
						620.1, 536.4, 427.4, 359, 311.7, 277.1, 250.5, 229.5,
						212.4, 159.5, 132, 115.2, 103.9, 89.81, 81.46, 76.04,
						72.3, 69.63, 67.66, 66.16 }, { 2520, 2770, 3230, 3630,
						3990, 4310, 4600, 4870, 5110, 5990, 6490, 6770, 6920,
						7030, 7000, 6900, 6770, 6630, 6480, 6320, 5600, 5000,
						4500, 4080, 3440, 2960, 2600, 2320, 2100, 1920, 1760,
						1270, 1010, 844.3, 730, 581.5, 488.4, 424.2, 377.1,
						340.9, 312.3, 289.1, 217.1, 179.8, 156.9, 141.6, 122.4,
						111, 103.6, 98.51, 94.88, 92.19, 90.15 }, { 2710, 2990,
						3510, 3960, 4370, 4740, 5070, 5380, 5670, 6750, 7410,
						7800, 8040, 8250, 8280, 8220, 8110, 7980, 7830, 7680,
						6920, 6240, 5670, 5190, 4420, 3840, 3390, 3030, 2750,
						2510, 2310, 1670, 1320, 1100, 954.2, 759.4, 637.7,
						553.9, 492.4, 445.3, 407.9, 377.6, 283.7, 235, 205.1,
						185.1, 159.9, 145.1, 135.4, 128.8, 124, 120.5, 117.9 },
						{ 2880, 3190, 3750, 4250, 4700, 5110, 5490, 5840, 6160,
								7440, 8250, 8760, 9080, 9400, 9500, 9480, 9400,
								9280, 9140, 8990, 8200, 7480, 6850, 6310, 5430,
								4750, 4220, 3800, 3450, 3160, 2910, 2120, 1680,
								1400, 1210, 961, 806.8, 700.8, 623, 563.4,
								516.2, 477.9, 359.2, 297.5, 259.8, 234.4, 202.6,
								183.8, 171.6, 163.2, 157.2, 152.7, 149.3 }, {
								3030, 3360, 3960, 4500, 4990, 5450, 5860, 6250,
								6610, 8070, 9040, 9670, 10100, 10500, 10700,
								10700, 10700, 10600, 10400, 10300, 9500, 8740,
								8070, 7470, 6490, 5720, 5110, 4620, 4210, 3860,
								3570, 2610, 2070, 1730, 1490, 1190, 995.9,
								864.9, 769, 695.5, 637.2, 589.9, 443.5, 367.5,
								320.9, 289.6, 250.3, 227.1, 212, 201.7, 194.2,
								188.7, 184.6 } } } };



int AT_ICRU_wrapper( const long n,
		const double E_MeV_u[],
		const long particle_no[],
		const long material_no,
		const char info[],
		double mass_stopping_power_MeV_cm2_g[]){

	long i;
	if((material_no != Water_Liquid) && (material_no != Aluminum_Oxide)){		/* Water and Alox data only */
		for(i = 0; i < n; i++){
			mass_stopping_power_MeV_cm2_g[i] = -1.0;
		}
		return AT_No_ICRU_Data;
	}

	long Z[n];
	AT_Z_from_particle_no(n, particle_no, Z);

	for(i = 0; i < n; i++){

		if( Z[i] > 18){				/* Data for H ... Ar */
			mass_stopping_power_MeV_cm2_g[i]	= -1.0;
			continue;
		}

		if (E_MeV_u[i] < 0.025 || E_MeV_u[i] > 1000){
			mass_stopping_power_MeV_cm2_g[i]	= -1.0;
			continue;
		}

		if (Z[i] == 2 && E_MeV_u[i] > 250){   // Data for He only until 250 MeV/u = 1000 MeV !
			mass_stopping_power_MeV_cm2_g[i]	= -1.0;
			continue;
		}

		mass_stopping_power_MeV_cm2_g[i] = AT_get_interpolated_y_from_input_table(
				AT_stopping_power_ICRU_table[material_no-1].energy_and_stopping_power[0],
				AT_stopping_power_ICRU_table[material_no-1].energy_and_stopping_power[Z[i]],
				AT_stopping_power_ICRU_table[material_no-1].number_of_data_points,
				E_MeV_u[i]);

		// TODO: remove after proper scaling of data
		if(material_no == Water_Liquid){
			mass_stopping_power_MeV_cm2_g[i] *= 1000;
		}
	}

	return AT_Success;
}

