% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.lgspline}
\alias{coef.lgspline}
\title{Extract model coefficients}
\usage{
\method{coef}{lgspline}(object, ...)
}
\arguments{
\item{object}{A fitted lgspline model object containing coefficient vectors.}

\item{...}{Not used.}
}
\value{
A list where each element corresponds to a partition and contains a single-column matrix
of coefficient values for that partition. Row names indicate the term type. Returns NULL if
coefficients are not found in the object.
\describe{
  \item{partition1, partition2, ...}{Matrices containing coefficients for each partition.}
}
}
\description{
Extracts polynomial coefficients for each partition from a fitted lgspline model.
}
\details{
For each partition, coefficients represent a polynomial expansion of the predictor(s) by column index, for example:
\itemize{
  \item intercept: Constant term
  \item v: Linear term
  \item v_^2: Quadratic term
  \item v^3: Cubic term
  \item _v_x_w_: Interaction between v and w
}

If column/variable names are present, indices will be replaced with column/variable names.

Coefficients can be accessed either as separate vectors per partition or combined into
a single matrix using \code{Reduce('cbind', coef(model_fit))}.
}
\examples{

## Simulate some data and fit using default settings
set.seed(1234)
t <- runif(1000, -10, 10)
y <- 2*sin(t) + -0.06*t^2 + rnorm(length(t))
model_fit <- lgspline(t, y)

## Extract coefficients
coefficients <- coef(model_fit)

## Print coefficients for first partition
print(coefficients[[1]])

## Compare coefficients across all partitions
print(Reduce('cbind', coefficients))

}
\seealso{
\code{\link{lgspline}}
}
