% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{Layout}
\alias{Layout}
\alias{Layouts}
\title{Abstract Class for Layouts}
\description{
Abstract Class for Layouts

Abstract Class for Layouts
}
\details{
\link{Appenders} pass \link[=LogEvent]{LogEvents} to a Layout which formats it for
output. For the Layouts included in lgr that means turning the LogEvent
into a \code{character} string.

For each Appender exist one more more possible Layouts, but not every Layout
will work with every Appender. See the package \pkg{lgrExtra} for examples
for Layouts that return different data types (such as \code{data.frames}) and
Appenders that can handle them.
}
\section{Notes for developers}{

Layouts may have an additional \verb{$read(file, threshold, n)} method that returns
a \code{character} vector, and/or an \verb{$parse(file)} method that
returns a \code{data.frame}. These can be used by Appenders to \verb{$show()} methods
and \verb{$data} active bindings respectively (see source code of \link{AppenderFile}).
}

\seealso{
Other Layouts: 
\code{\link{LayoutFormat}},
\code{\link{LayoutGlue}},
\code{\link{LayoutJson}}
}
\concept{Layouts}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Layout-format_event}{\code{Layout$format_event()}}
\item \href{#method-Layout-toString}{\code{Layout$toString()}}
\item \href{#method-Layout-clone}{\code{Layout$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Layout-format_event"></a>}}
\if{latex}{\out{\hypertarget{method-Layout-format_event}{}}}
\subsection{Method \code{format_event()}}{
Format a log event

Function that the Layout uses to transform a \link{LogEvent} into something
that an \link{Appender} can write to an output destination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Layout$format_event(event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{a \link{LogEvent}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Layout-toString"></a>}}
\if{latex}{\out{\hypertarget{method-Layout-toString}{}}}
\subsection{Method \code{toString()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Layout$toString()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Layout-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Layout-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Layout$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
